#!/bin/bash
#: Title      : test_resdel
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../resdel$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f mrglu.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 0.1.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f output.res 
$PROGRAM -stupidoption -o=output.res mrglu.res bluf 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   General tests \n"
printf "===================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: delete one region based on name. \n"
printf " Test case 2: save in new file. \n"
printf " Expected result: New file has correct contents. \n\n"

rm -f output.res
$PROGRAM -o=output.res mrglu.res tis1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -header=y -param=y -regions=y correct_100.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: delete one region based on number. \n"
printf " Test case 2: save in new file. \n"
printf " Expected result: New file has correct contents. \n\n"

rm -f output.res
$PROGRAM -o=output.res mrglu.res 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -header=y -param=y -regions=y correct_100.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: delete two regions based on name. \n"
printf " Test case 2: save in new file. \n"
printf " Expected result: New file has correct contents. \n\n"

rm -f output.res
$PROGRAM -o=output.res mrglu.res tis1 tis5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -header=y -param=y -regions=y correct_110.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: delete two regions based on number. \n"
printf " Test case 2: save in new file. \n"
printf " Expected result: New file has correct contents. \n\n"

rm -f output.res
$PROGRAM -o=output.res mrglu.res 2 6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -header=y -param=y -regions=y correct_110.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: dry mode. \n"
printf " Expected result: Nothing is changed. \n\n"

cp -f mrglu.res temp.res
$PROGRAM --dry temp.res 2 6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -header=y -param=y -regions=y mrglu.res temp.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case 1: delete two regions based on number. \n"
printf " Test case 2: optional output file is not given. \n"
printf " Expected result: Modified file has correct contents. \n\n"

cp -f mrglu.res temp.res
$PROGRAM temp.res 2 6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -header=y -param=y -regions=y correct_110.res temp.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Failures \n"
printf "===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexisting.res cereb 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexisting.res'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.0 \n"
printf " Test case: specified region name does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -o=output.res mrglu.res stupid 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "stupid did not match with any of the regions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 \n"
printf " Test case: one of specified region names does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -o=output.res mrglu.res tis1 stupid 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "stupid did not match with any of the regions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

