#!/bin/bash
#: Title      : test_ainterp
#: Date       : 2014-07-11
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ ! -z $OS ] && [ $OS eq "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ainterp$EXT;

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\nTest 1\n"

$PROGRAM ainterp_example.dat 0 output1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.005 ainterp_correct_output1.dat output1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\nTest 2\n"

$PROGRAM ainterp_example.dat 10 output2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.005 ainterp_correct_output2.dat output2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\nTest 3\n"

$PROGRAM ainterp_example.dat 30 output3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.005 ainterp_correct_output3.dat output3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\nTest 4\n"

$PROGRAM ainterp_example2.dat 35 output4.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.005 ainterp_correct_output4.dat output4.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"
printf "  All passed.\n"
printf "===================================================================\n"
exit 0

