#!/bin/bash
#: Title      : test_dftweigh
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dftweigh$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f dftweigh.dft ] || [ ! -f dftweigh.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f dftweigh_nocalunit.dft ] || [ ! -f dftweigh_notimeunit.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct1.dft ] || [ ! -f correct2.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct3.dft ] || [ ! -f correct3b.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct4a.tac ] || [ ! -f correct4c.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f dftweigh.tac ] || [ ! -f correct1.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Add weights from SIF. \n"
printf " Test case 2: List weights in TAC file. \n"
printf " Expected result 1: Correct weights are added. \n"
printf " Expected result 2: Fail if no weights. \n\n"

cp -f dftweigh.dft temp1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "are there weights?\n"
$PROGRAM -L temp1.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -moderate=200 -i=C-11 temp1.dft dftweigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 correct1.dft temp1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "are there weights?\n"
$PROGRAM -L temp1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Remove weights from file made above. \n"
printf " Expected result: Weights are removed. \n\n"

cp -f temp1.dft temp1b.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -rm temp1b.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 dftweigh.dft temp1b.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -L temp1b.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case: Add weights based on weighted average of TACs. \n"
printf " Expected result: Correct weights are added. \n\n"

cp -f dftweigh.dft temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -moderate=200 temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 correct2.dft temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.0 \n"
printf " Test case 1: Add weights based on one TAC. \n"
printf " Test case 2: Make SIF based on the selected TAC. \n"
printf " Expected result 1: Correct weights are added to TAC file. \n"
printf " Expected result 2: Correct SIF is made. \n\n"

cp -f dftweigh.dft temp3.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f head.sif

$PROGRAM -moderate=200 -i=C-11 -sif=head.sif temp3.dft head
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 correct3.dft temp3.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.0.1 \n"
printf " Test case: Add weights based on SIF made above. \n"
printf " Expected result: Correct weights are added to TAC file. \n\n"

$PROGRAM -moderate=100 temp3.dft head.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 correct3b.dft temp3.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n\n"

printf "\n 4.0.0 \n"
printf " Test case: Missing calibration units. \n"
printf " Expected result: Error. \n\n"

cp -f dftweigh_nocalunit.dft tempa.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM tempa.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 4.0.1 \n"
printf " Test case: Missing time units. \n"
printf " Expected result: Error. \n\n"

cp -f dftweigh_notimeunit.dft tempa.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM tempa.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 4.1.0 \n"
printf " Test case: Plane data with units. \n"
printf " Expected result: No error. \n\n"

rm -f dftweigh.dat
tacformat -format=simple -hdr=y -mid dftweigh.dft dftweigh.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
echo "# timeunit := sec"  >> dftweigh.dat
echo "# unit := kBq/mL"  >> dftweigh.dat
echo "# studynr := test001"  >> dftweigh.dat
cp -f dftweigh.dat dftweigh2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM dftweigh.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -L dftweigh.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.1 \n"
printf " Test case: Weighs can be removed from plain data. \n"
printf " Expected result: Weights are removed. \n\n"

$PROGRAM -rm dftweigh.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 dftweigh2.dat dftweigh.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -L dftweigh.dat
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n\n"



printf "\n 5.0.0 \n"
printf " Test case 1: Add weights to PMOD file from SIF. \n"
printf " Test case 2: List weights in TAC file. \n"
printf " Expected result 1: Correct weights are added. \n"
printf " Expected result 2: Fail if no weights. \n\n"

cp -f dftweigh.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "are there weights?\n"
$PROGRAM -L temp1.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -moderate=200 -i=C-11 temp1.tac dftweigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 correct1.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "are there weights?\n"
$PROGRAM -L temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.0.1 \n"
printf " Test case: Remove weights from PMOD file made above. \n"
printf " Expected result: Weights are removed. \n\n"

cp -f temp1.tac temp1b.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -rm temp1b.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.0005 -rel=0.1 dftweigh.tac temp1b.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -L temp1b.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n\n"

printf "\n 6.0.0 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: Option -wf. \n"
printf " Expected result: Correct weights are added. \n\n"

cp -f dftweigh.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wf temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.005 -rel=1 correct4a.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " Optional isotope does not affect the result \n\n"

cp -f dftweigh.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wf -i=C11 temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.005 -rel=1 correct4a.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 6.1.0 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: Option -wfm. \n"
printf " Expected result: Moderation does not affect this case. \n\n"

cp -f dftweigh.tac temp2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wfm temp2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.005 -rel=1 correct4a.tac temp2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 6.2.0 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: Option -wfd with isotope. \n"
printf " Expected result: Correct weights are added. \n\n"

cp -f dftweigh.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wfd -i=C-11 temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.002 -rel=0.1 correct4c.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 6.2.1 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: Option -wfd without isotope. \n"
printf " Expected result: Error. \n\n"

cp -f dftweigh.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wfd temp3.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "option -wfd cannot be used without isotope."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 6.2.2 \n"
printf " Test case 1: Add weights based on SIF frame durations. \n"
printf " Test case 2: Option -wfd and isotope inside TAC file. \n"
printf " Expected result: Correct weights are added. \n\n"

printf "# isotope := C-11\n" >> temp3.tac
iftlist temp3.tac isotope
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wfd temp3.tac dftweigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.002 -rel=0.1 correct4c.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 6.2.3 \n"
printf " Test case 1: Add weights based on SIF frame durations. \n"
printf " Test case 2: Option -wfd and isotope with option -i. \n"
printf " Expected result: Correct weights are added. \n\n"

cp -f dftweigh.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wfd -i=C-11 temp3.tac dftweigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -w=y -abs=0.002 -rel=0.1 correct4c.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

