#!/bin/bash
#: Title      : test_dftcbv
#: Date       : 2014-11-05
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dftcbv$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f blood.dat ] || [ ! -f blood0.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f tissue.dat ] || [ ! -f vb.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f true_output1.dat ] || [ ! -f true_output2.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f true_output3.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Vb correction with fixed Vb and no options. \n"
printf " Test case 2: Reversing previous correction with option -sim. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output1.dat

$PROGRAM tissue.dat blood0.dat 5 output1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=0.0001 -x=y -y=y -xunit=y -yunit=y true_output1.dat output1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sim output1.dat blood0.dat 5 output1b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=0.0001 -x=y -y=y -xunit=y -yunit=y tissue.dat output1b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Vb correction with fixed Vb, with option -tv. \n"
printf " Test case 2: Reversing previous correction with option -sim. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output2.dat

$PROGRAM -tv tissue.dat blood0.dat 5 output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.01 -x=y -y=y -xunit=y -yunit=y true_output2.dat output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sim -tv output2.dat blood0.dat 5 output2b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.01 -x=y -y=y -xunit=y -yunit=y tissue.dat output2b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Vb correction based on Vb file, with option -noneg. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output3.dat

$PROGRAM -noneg tissue.dat blood0.dat vb.dat output3.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.01 -x=y -y=y -xunit=y -yunit=y true_output3.dat output3.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Vb correction based on Vb file, with option -tv. \n"
printf " Test case 2: Reversing previous correction with option -sim. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output4.dat

$PROGRAM -tv tissue.dat blood0.dat vb.dat output4.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -sim -tv output4.dat blood0.dat vb.dat output4b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.01 -x=y -y=y -xunit=y -yunit=y tissue.dat output4b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

