#!/bin/bash
#: Title      : test_dftinteg
#: Date       : 2014-10-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dftinteg$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


echo ""
echo ===============================================================================
echo "testing "$PROGRAM
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.1.1: No command line options or arguments. Error with user info."
$PROGRAM 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.1.2: Unknown option."
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -stupidoption test_dyn.dft 0 0 output.dft 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.1.3: Extra argument."
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM test_dyn.dft 0 0 output.dft extra 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.1.4: Missing argument."
$PROGRAM 0 0 output.dft
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
$PROGRAM test_dyn.dft 0 output.dft
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
$PROGRAM test_dyn.dft 0 0
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.5.1: option -avg"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 -avg test_dyn.dft 0 0 output.dft > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt calc_avg "1"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 test_dyn.dft 0 0 output.dft > stdout.txt
iftisval stdout.txt calc_avg "0"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "2.1.1: AUC from full frames"
$PROGRAM test_dyn.dft 3 12 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch correct_dynfull.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "2.1.2: AUC from partial frames"
$PROGRAM test_dyn.dft 2.5 12.5 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_dynpartial1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

$PROGRAM test_dyn.dft 5 11 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_dynpartial2.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

$PROGRAM test_dyn.dft 8 4 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_dynpartial3.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "2.2.1: Gaps or overlaps between frames"
echo "       Small gap"
$PROGRAM test_dyn.dft 1 14 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
$PROGRAM test_smallgap.dft 1 14 output2.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=1 output.dft output2.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       Large gap"
$PROGRAM test_largegap.dft 1 14 output3.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=1 output.dft output3.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       Small overlap"
$PROGRAM test_smalloverlap.dft 1 14 output4.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=1 output.dft output4.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       Large overlap"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM test_largeoverlap.dft 1 14 temp.dft 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt "Error" "test_largeoverlap.dft has overlapping frame times."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "3.1.1: AUC from zero to certain end time."
$PROGRAM test_dyn.dft 0 15 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch correct_fromstart1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "3.1.2: Same but with mid times only."
tacformat -mid -format=simple -hdr=no test_dyn.dft test_dyn.dat
$PROGRAM test_dyn.dat 0 15 output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
interpol -i -a -x=15 test_dyn.dat temp.dat 
tacmatch -x=n temp.dat output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "3.2.1: AUC from zero to a late end time."
echo "       small extrapolation of end necessary"
$PROGRAM test_dyn.dft 0 40 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch correct_extrapol1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       large extrapolation would be necessary: error"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM test_dyn.dft 0 60 output.dft 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt "Error" "integration time range oversteps data range"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "3.2.2: Same but with mid times only."
$PROGRAM test_dyn.dat 0 30 output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
interpol -i -a -x=30 test_dyn.dat temp.dat 
tacmatch -x=n temp.dat output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       large extrapolation would be necessary: error"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM test_dyn.dat 0 60 output.dat 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt "Error" "integration time range oversteps data range"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "3.3.1: AUC from zero to a late end time."
echo "       small extrapolation of start is necessary"
$PROGRAM test_dyn2.dft 0 15 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_extrapol2.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       large extrapolation would be necessary: error"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM test_latescan.dft 0 60 output.dft 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt "Error" "integration time range oversteps data range"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "3.3.2: Same but with mid times only."

echo "       small extrapolation of start is necessary"
tacformat -format=simple -mid -hdr=n test_dyn2.dft test_dyn2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM test_dyn2.dat 0 15 output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
interpol -i -a=0.1 -x=15 test_dyn2.dat temp.dat 
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.1 -rel=0.5 -x=n temp.dat output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo "       large extrapolation would be necessary: error"
tacformat -mid -format=simple -hdr=n test_latescan.dft test_latescan.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM test_latescan.dat 0 60 output.dat 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt "Error" "integration time range oversteps data range"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "4.1.1: Average of dynamic data between two late times"
$PROGRAM -avg test_dyn.dft 10 15 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_fromend1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "4.1.2: Same but with mid times only."
$PROGRAM -avg test_dyn.dat 10 15 output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 -x=n correct_fromend1.dft output.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "4.2.1: TAC data stops before calculation time range even begins"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -avg test_dyn.dft 120 60 output.dft 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt "Error" "integration time range oversteps data range"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "4.3.1: Average TAC data stops before calculation time range even begins"
$PROGRAM -avg test_latescan.dft 0 0 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_latescan1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "5.1.1: Integral from static study for ARG method"
$PROGRAM test_arg1.dft 0 90 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_arg1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "5.1.2: Same as before but program sets the time range based on data"
$PROGRAM test_arg1.dft 0 0 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_arg1.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "5.2.1: Frame does not start from zero time. Program sets the time range."
$PROGRAM test_arg2.dft 0 0 output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
tacmatch -abs=0.1 -rel=0.1 correct_arg2.dft output.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "6.1.1: Saved in RES format"
$PROGRAM test_dyn.dft 3 12 output.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
dft2res correct_dynfull.dft
echo passed.
resmatch correct_dynfull.res output.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo ""
#exit 0
echo ""
rm stdout.* stderr.*
echo ===============================================================================
echo ""
echo "All passed!"
echo ""
echo ===============================================================================
exit 0

