#!/bin/bash
#: Title      : test_abssbkg
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../abssbkg$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f ../data/us1328.bld ] || [ ! -f ../data/ep0152_blo.lis ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/t00061.alg ] || [ ! -f ../data/ME_ABSS09282_is731dy1.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: GEMS file with option --dry. \n"
printf " Expected result 1: Original file is not modified. \n"
printf " Expected result 2: Correct background printed in stdout. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM --dry test.bld 60  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.01 stdout.txt background_ch1[cps] 4.35000000
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 stdout.txt background_ch2[cps] 1.91666667
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: GEMS file with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct results saved to specified file. \n\n"

rm -f output.bld
cp -f ../data/us1328.bld test.bld

$PROGRAM -o=output.bld test.bld 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/us1328.bld output.bld
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry output.bld 60  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry output.bld 3000  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 111.544
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 113.166
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: GEMS file without options. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct results saved. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry test.bld 60  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n 1.1.0 \n"
printf " Test case: Scanditronics file with option --dry. \n"
printf " Expected result: Correct background printed in stdout. \n\n"

cp -f ../data/ep0152_blo.lis test_blo.lis

$PROGRAM --dry test_blo.lis 30  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 stdout.txt background_ch1[cps] 1.13333333
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 stdout.txt background_ch2[cps] 4.30000000
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Scanditronics file without options. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct results saved. \n\n"

cp -f ../data/ep0152_blo.lis test_blo.lis

$PROGRAM test_blo.lis 30
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ep0152_blo.lis test_blo.lis
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry test_blo.lis 30  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry test_blo.lis 3000  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 520.114
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 649.695
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"

printf "\n 1.2.0 \n"
printf " Test case: Allogg 1 file with option --dry. \n"
printf " Expected result 1: Original file is not modified. \n"
printf " Expected result 2: Correct background printed in stdout. \n\n"

cp -f ../data/t00061.alg test.alg

$PROGRAM --dry test.alg 30  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/t00061.alg test.alg
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.01 stdout.txt background_ch1[cps] 17.40000
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 stdout.txt background_ch2[cps] 3.766667
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.1 \n"
printf " Test case: Allogg 1 file without options. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct results saved. \n\n"

cp -f ../data/t00061.alg test.alg

$PROGRAM test.alg 30
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/t00061.alg test.alg
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry test.alg 30  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry test.alg 3000  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 2559.14
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 662.71
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"

printf "\n 1.3.0 \n"
printf " Test case: Allogg 2 file with option --dry. \n"
printf " Expected result 1: Original file is not modified. \n"
printf " Expected result 2: Correct background printed in stdout. \n\n"

cp -f ../data/ME_ABSS09282_is731dy1.txt allogg.txt

$PROGRAM --dry allogg.txt 40  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt allogg.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.01 stdout.txt background_ch1[cps] 87.150
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 stdout.txt background_ch2[cps] 22.675
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.3.1 \n"
printf " Test case: Allogg 2 file without options. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct results saved. \n\n"

cp -f ../data/ME_ABSS09282_is731dy1.txt allogg.txt

$PROGRAM allogg.txt 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt allogg.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry allogg.txt 40  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --dry allogg.txt 3000  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch1[cps] 3126.23
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.5 stdout.txt background_ch2[cps] 932.147
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM -stupidoption test.bld 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 60 extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.dat 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case: Wrong file format. \n"
printf " Expected result: Error. \n\n"

simcirc -format=csv 32 20 test.bld
$PROGRAM test.bld 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

simcirc -format=short 32 20 test.bld
$PROGRAM test.bld 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

