#!/bin/bash
#: Title      : test_absstime
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../absstime$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f ../data/us1328.bld ] || [ ! -f ../data/ep0152_blo.lis ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/t00061.alg ] || [ ! -f ../data/ME_ABSS09282_is731dy1.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case 1: List time information. \n"
printf " Test case 2: Scanditronics file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct output to stdout. \n\n"

rm -f stdout1.txt
cp -f ../data/ep0152_blo.lis test_blo.lis

$PROGRAM test_blo.lis > stdout1.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ep0152_blo.lis test_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout1.txt fileformat "ABSS-Scanditronics"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt date "2004-09-24"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt zero_time "11:36:28"
if [ $? -ne 0 ] ; then 
  iftisval stdout1.txt zero_time "10:36:28" ; 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
printf "\n ok \n"
iftisval stdout1.txt first_sample_time "11:36:28"
if [ $? -ne 0 ] ; then 
  iftisval stdout1.txt first_sample_time "10:36:28" ; 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout1.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout1.txt sampling_time[s] 400
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: List time information. \n"
printf " Test case 2: GEMS file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct output to stdout. \n\n"

rm -f stdout2.txt
cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld > stdout2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout2.txt fileformat "ABSS-GEMS"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt date "2008-01-22"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt zero_time "10:52:09"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt first_sample_time "10:52:09"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout2.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout2.txt sampling_time[s] 180
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: List time information. \n"
printf " Test case 2: Allogg 1 file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct output to stdout. \n\n"

rm -f stdout3.txt
cp -f ../data/t00061.alg test.alg

$PROGRAM test.alg > stdout3.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/t00061.alg test.alg
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout3.txt fileformat "ABSS-ALLOGG-OLD"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt date "2005-05-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt zero_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt first_sample_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout3.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout3.txt sampling_time[s] 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: List time information. \n"
printf " Test case 2: Allogg 2 file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct output to stdout. \n\n"

rm -f stdout4.txt
cp -f ../data/ME_ABSS09282_is731dy1.txt allogg.txt

$PROGRAM allogg.txt > stdout4.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt allogg.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout4.txt fileformat "ABSS-ALLOGG"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt date "2010-05-17"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt zero_time "12:31:37"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt first_sample_time "12:31:37"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout4.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout4.txt sampling_time[s] 360
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.0.4 \n"
printf " Test case 1: List time information. \n"
printf " Test case 2: Allogg file which for reason stops with NUL character. \n"
printf " Expected result 1: File can be read. \n"
printf " Expected result 2: Correct output to stdout. \n\n"

rm -f stdout5.txt

$PROGRAM ../data/P109882.alg > stdout5.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



#cat stdout?.txt

printf "=====================================================================\n"


printf "\n 1.1.0 \n"
printf " Test case 1: The same start time given. \n"
printf " Test case 2: Scanditronics file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Notification printed in stdout. \n\n"

rm -f stdout1.txt stdout2.txt
cp -f ../data/ep0152_blo.lis test_blo.lis

$PROGRAM test_blo.lis > stdout2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout2.txt first_sample_time "11:36:28"
if [ $? -eq 0 ] ; then  
  $PROGRAM test_blo.lis 11:36:28 > stdout1.txt
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  iftisval stdout1.txt zero_time "11:36:28"
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  iftisval stdout1.txt first_sample_time "11:36:28"
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
else
  $PROGRAM test_blo.lis 10:36:28 > stdout1.txt
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  iftisval stdout1.txt zero_time "10:36:28"
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  iftisval stdout1.txt first_sample_time "10:36:28"
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

tacmatch -abs=0.05 ../data/ep0152_blo.lis test_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout1.txt date "2004-09-24"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout1.txt "Note" "start times are not different; file not changed."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.1 \n"
printf " Test case 1: The same start time given. \n"
printf " Test case 2: GEMS file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Notification printed in stdout. \n\n"

rm -f stdout2.txt
cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 10:52:09 > stdout2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout2.txt date "2008-01-22"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt zero_time "10:52:09"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt first_sample_time "10:52:09"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt "Note" "start times are not different; file not changed."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case 1: The same start time given. \n"
printf " Test case 2: Allogg 1 file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Notification printed in stdout. \n\n"

rm -f stdout3.txt
cp -f ../data/t00061.alg test.alg

$PROGRAM test.alg 11:29:33 > stdout3.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/t00061.alg test.alg
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout3.txt date "2005-05-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt zero_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt first_sample_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt "Note" "start times are not different; file not changed."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.3 \n"
printf " Test case 1: The same start time given. \n"
printf " Test case 2: Allogg 2 file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Notification printed in stdout. \n\n"

rm -f stdout4.txt
cp -f ../data/ME_ABSS09282_is731dy1.txt allogg.txt

$PROGRAM allogg.txt 12:31:37 > stdout4.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt allogg.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout4.txt date "2010-05-17"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt zero_time "12:31:37"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt first_sample_time "12:31:37"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt "Note" "start times are not different; file not changed."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"




printf "\n 2.0.0 \n"
printf " Test case 1: Set start time to 1 min 5 s earlier. \n"
printf " Test case 2: Scanditronics file. \n"
printf " Test case 3: Output file given with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout1.txt output_blo.lis
cp -f ../data/ep0152_blo.lis test_blo.lis

$PROGRAM -o=output_blo.lis test_blo.lis 11:35:23
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output_blo.lis > stdout1.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ep0152_blo.lis test_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/ep0152_blo.lis output_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout1.txt fileformat "ABSS-Scanditronics"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt date "2004-09-24"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt zero_time "11:35:23"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt first_sample_time "11:35:23"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout1.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout1.txt sampling_time[s] 400
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Set start time to 1 min 5 s earlier. \n"
printf " Test case 2: GEMS file. \n"
printf " Test case 3: Output file given with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout2.txt output.bld
cp -f ../data/us1328.bld test.bld

$PROGRAM -o=output.bld test.bld 10:51:04
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.bld > stdout2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/us1328.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout2.txt fileformat "ABSS-GEMS"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt date "2008-01-22"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt zero_time "10:51:04"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt first_sample_time "10:51:04"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout2.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout2.txt sampling_time[s] 180
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case 1: Set start time to 1 min 5 s earlier. \n"
printf " Test case 2: Allogg 1 file. \n"
printf " Test case 3: Output file given with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout3.txt output.alg
cp -f ../data/t00061.alg test.alg

$PROGRAM -o=output.alg test.alg 11:28:28
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.alg > stdout3.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/t00061.alg test.alg
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/t00061.alg output.alg
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout3.txt fileformat "ABSS-ALLOGG-OLD"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt date "2005-05-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt zero_time "11:28:28"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt first_sample_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout3.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout3.txt sampling_time[s] 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.3 \n"
printf " Test case 1: Set start time to 1 min 5 s earlier. \n"
printf " Test case 2: Allogg 2 file. \n"
printf " Test case 3: Output file given with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout4.txt output_allogg.txt
cp -f ../data/ME_ABSS09282_is731dy1.txt allogg.txt

$PROGRAM -o=output_allogg.txt allogg.txt 12:30:32
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output_allogg.txt > stdout4.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt allogg.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt output_allogg.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout4.txt fileformat "ABSS-ALLOGG"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt date "2010-05-17"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt zero_time "12:30:32"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt first_sample_time "12:30:32"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout4.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout4.txt sampling_time[s] 360
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


#cat stdout?.txt


printf "=====================================================================\n"


printf "\n 2.1.0 \n"
printf " Test case 1: Set start time to 1 min 5 s later. \n"
printf " Test case 2: Scanditronics file. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout1.txt

$PROGRAM output_blo.lis 11:36:28
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output_blo.lis > stdout1.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ep0152_blo.lis output_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout1.txt fileformat "ABSS-Scanditronics"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt date "2004-09-24"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt zero_time "11:36:28"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout1.txt first_sample_time "11:36:28"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout1.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout1.txt sampling_time[s] 400
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case 1: Set start time to 1 min 5 s later. \n"
printf " Test case 2: GEMS file. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout2.txt

$PROGRAM output.bld 10:52:09
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.bld > stdout2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout2.txt fileformat "ABSS-GEMS"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt date "2008-01-22"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt zero_time "10:52:09"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout2.txt first_sample_time "10:52:09"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout2.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout2.txt sampling_time[s] 180
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.2 \n"
printf " Test case 1: Set start time to 1 min 5 s later. \n"
printf " Test case 2: Allogg 1 file. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout3.txt

$PROGRAM output.alg 11:29:33
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.alg > stdout3.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/t00061.alg output.alg
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout3.txt fileformat "ABSS-ALLOGG-OLD"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt date "2005-05-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt zero_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout3.txt first_sample_time "11:29:33"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout3.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout3.txt sampling_time[s] 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.3 \n"
printf " Test case 1: Set start time to 1 min 5 s later. \n"
printf " Test case 2: Allogg 2 file. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct file contents written. \n\n"

rm -f stdout4.txt

$PROGRAM output_allogg.txt 12:31:37
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output_allogg.txt > stdout4.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt output_allogg.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout4.txt fileformat "ABSS-ALLOGG"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt date "2010-05-17"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt zero_time "12:31:37"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout4.txt first_sample_time "12:31:37"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout4.txt sample_interval[s] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 stdout4.txt sampling_time[s] 360
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


cat stdout?.txt

printf "=====================================================================\n"

printf "\n 3.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM -stupidoption test.bld 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 13:45:00 extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.dat 13:45:00 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

