#!/bin/bash
#: Title      : test_absszero
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../absszero$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f ../data/us1328.bld ] || [ ! -f ../data/ep0152_blo.lis ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/t00061.alg ] || [ ! -f ../data/ME_ABSS09282_is731dy1.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: GEMS file with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct results saved to specified file. \n\n"

rm -f output.bld
cp -f ../data/us1328.bld test.bld
rm -f original.ift output.ift

$PROGRAM -o=output.bld test.bld 0 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/us1328.bld output.bld
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry output.bld 60  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry ../data/us1328.bld 9999  > original.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
abssbkg --dry output.bld 9999  > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=5 original.ift output.ift background_ch1[cps]
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=5 original.ift output.ift background_ch2[cps] 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: GEMS file without options. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct results saved. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 0 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry test.bld 60  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"



printf "\n 1.1.0 \n"
printf " Test case: Scanditronics file with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct results saved to specified file. \n\n"

rm -f output_blo.lis
cp -f ../data/ep0152_blo.lis test_blo.lis
rm -f original.ift output.ift

$PROGRAM -o=output_blo.lis test_blo.lis 0 30
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ep0152_blo.lis test_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/ep0152_blo.lis output_blo.lis
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry output_blo.lis 30  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry ../data/ep0152_blo.lis 9999  > original.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
abssbkg --dry output_blo.lis 9999  > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=5 original.ift output.ift background_ch1[cps]
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=5 original.ift output.ift background_ch2[cps] 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"



printf "\n 1.2.0 \n"
printf " Test case: Allogg 1 file with option -o. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct results saved to specified file. \n\n"

rm -f output.alg
cp -f ../data/t00061.alg test.alg
rm -f original.ift output.ift

$PROGRAM -o=output.alg test.alg 0 30
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/t00061.alg test.alg
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 ../data/t00061.alg output.alg
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry output.alg 30  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry ../data/t00061.alg 9999  > original.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
abssbkg --dry output.alg 9999  > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=5 original.ift output.ift background_ch1[cps]
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=5 original.ift output.ift background_ch2[cps] 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "=====================================================================\n"



printf "\n 1.3.0 \n"
printf " Test case: Allogg 2 file without options. \n"
printf " Expected result 1: Original file is modified. \n"
printf " Expected result 2: Correct results saved to specified file. \n\n"

cp -f ../data/ME_ABSS09282_is731dy1.txt allogg.txt
rm -f original.ift output.ift

$PROGRAM allogg.txt 0 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ME_ABSS09282_is731dy1.txt allogg.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry allogg.txt 40  > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch1[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt background_ch2[cps] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

abssbkg --dry ../data/ME_ABSS09282_is731dy1.txt 9999  > original.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
abssbkg --dry allogg.txt 9999  > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=20 original.ift output.ift background_ch1[cps]
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=20 original.ift output.ift background_ch2[cps] 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM -stupidoption test.bld 0 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 0 60 extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.dat 0 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case: Wrong file format. \n"
printf " Expected result: Error. \n\n"

simcirc -format=csv 32 20 test.bld
$PROGRAM test.bld 0 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

simcirc -format=short 32 20 test.bld
$PROGRAM test.bld 0 60 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

