#!/bin/bash
#: Title      : test_perfrat
#: Date       : 2019-02-28
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../perfrat$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f rabbit34.tac ] || [ ! -f rabbit35.tac ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f correct34.par ] || [ ! -f correct35.par ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f correct34et.par ] || [ ! -f correct34fr.par ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Perfusion ratio from test data 1. \n"
printf " Expected result: correct peak times and AUC ratios. \n\n"

rm -f output34.par
$PROGRAM rabbit34.tac CTRL output34.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 correct34.par output34.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Perfusion ratio from test data 2. \n"
printf " Expected result: correct peak times and AUC ratios. \n\n"

rm -f output35.par
$PROGRAM rabbit35.tac CTRL output35.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 correct35.par output35.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Extend calculation time. \n"
printf " Expected result: correct AUC ratios. \n\n"

rm -f output34et.par
$PROGRAM -etime=15 rabbit34.tac CTRL output34et.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 correct34et.par output34et.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Option -fr. \n"
printf " Expected result: correct peak times and AUC ratios. \n\n"

rm -f output34fr.par
$PROGRAM -fr rabbit34.tac CTRL_cortex output34fr.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 correct34fr.par output34fr.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n=====================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: Reference name not in file. \n"
printf " Expected result: Error. \n\n"

$PROGRAM rabbit34.tac heyhou
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM rabbit34.tac 99
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

