#!/bin/bash
#: Title      : test_bfmsrtm
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../bfmsrtm$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f plasma.dat ] || [ ! -f frames.dat ] || [ ! -f shortframes.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f perfect.par ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_110.par ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f perfect.tac ]; then
  printf "\n Simulate TTACs applying SRTM\n"
  p2t_3c --silent -nosub plasma.dat  0.100 0.120 0 0 0 0 ref.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren ref.tac 1 ref
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  sim_rtcm perfect.par ref.tac perf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd perf.tac ref.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe perf.tac shortframes.dat perfect.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=yes perfect.svg perfect.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Reasonable noiseless data. \n"
printf " Test case 2: Weighting by frame length. \n"
printf " Expected result 1: Correct results calculated. \n"
printf " Expected result 2: Optional SVG plot and BF data files are created. \n\n"

rm -f output100.par output100.svg

$PROGRAM -d3 -wf -nr=1000 -bf=bf100.tac -svg=output100.svg -min=0.009 -max=0.4 perfect.tac ref output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.001 -rel=2 perfect.par output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output100.par fit_end 120
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output100.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f bf100.tac ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Reasonable noiseless data. \n"
printf " Test case 2: No weighting. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output101.par output101.svg

$PROGRAM -w1 -nr=1000 -svg=output101.svg -min=0.001 perfect.tac ref output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.001 -rel=2 perfect.par output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: DVR is saved instead of BPnd. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output110.par

$PROGRAM -nr=1000 -DVR perfect.tac ref output110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.001 -rel=2 correct_110.par output110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Optional fit time set. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output120.par

$PROGRAM -end=60 -nr=1000 perfect.tac ref output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.002 -rel=4 perfect.par output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output120.par fit_end 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Reference TAC is given in separate file. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output130.par output130.svg
cp -f perfect.tac temp.tac
tacadd -ovr perfect_ref.tac perfect.tac ref
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacdel temp.tac ref
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -nr=1000 -svg=output130.svg temp.tac perfect_ref.tac output130.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.001 -rel=2 perfect.par output130.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: Reference TAC sample times in sec. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output131.par output131.svg
tacunit -xconv=sec perfect_ref.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -nr=1000 -svg=output131.svg temp.tac perfect_ref.tac output131.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.001 -rel=2 perfect.par output131.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.4.0 \n"
printf " Test case: Optional isotope given. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output140.par output140.svg

$PROGRAM -i=C-11 -nr=1000 -svg=output140.svg perfect.tac ref output140.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1-3 -abs=0.002 -rel=3 perfect.par output140.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption perfect.tac ref output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM perfect.tac ref output.par extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM perfect.tac output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM perfect.tac ref 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.dat ref output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM perfect.tac nonexistingfile.tac output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Wrong file format. \n"
printf " Expected result: Error. \n\n"

$PROGRAM perfect.par perfect.tac output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM perfect.tac perfect.par output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

