#!/bin/bash
#: Title      : test_csvrmcol
#: Date       : 2020-04-27
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../csvrmcol$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f data1.tsv ] || [ ! -f data1.csv ] || [ ! -f correct_data1.csv ]; then
  printf "No	time[seconds] 	parent[kBq/cc]\n" > data1.tsv
  printf "1	0.5	0.04\n" >> data1.tsv
  printf "2	1.5	0.02\n" >> data1.tsv
  printf "3	2.5	0.08\n" >> data1.tsv
  printf "4	3.5	0.13\n" >> data1.tsv

  printf "No,time[seconds],parent[kBq/cc]\n" > data1.csv
  printf "1,0.5,0.04\n" >> data1.csv
  printf "2,1.5,0.02\n" >> data1.csv
  printf "3,2.5,0.08\n" >> data1.csv
  printf "4,3.5,0.13\n" >> data1.csv

  printf "time[seconds],parent[kBq/cc]\n" > correct_data1.csv
  printf "0.5,0.04\n" >> correct_data1.csv
  printf "1.5,0.02\n" >> correct_data1.csv
  printf "2.5,0.08\n" >> correct_data1.csv
  printf "3.5,0.13\n" >> correct_data1.csv
fi

if [ ! -f data2.csv ] || [ ! -f correct_data2a.csv ] || [ ! -f correct_data2b.csv ]; then
  printf "time[seconds],tac1[kBq/cc],tac2\n" > data2.csv
  printf "0.5,0.04,0.14\n" >> data2.csv
  printf "1.5,0.02,0.12\n" >> data2.csv
  printf "2.5,0.08,0.18\n" >> data2.csv
  printf "3.5,0.13,0.23\n" >> data2.csv

  printf "time[seconds],tac1[kBq/cc]\n" > correct_data2a.csv
  printf "0.5,0.04\n" >> correct_data2a.csv
  printf "1.5,0.02\n" >> correct_data2a.csv
  printf "2.5,0.08\n" >> correct_data2a.csv
  printf "3.5,0.13\n" >> correct_data2a.csv

  printf "time[seconds],tac2[kBq/cc]\n" > correct_data2b.csv
  printf "0.5,0.14\n" >> correct_data2b.csv
  printf "1.5,0.12\n" >> correct_data2b.csv
  printf "2.5,0.18\n" >> correct_data2b.csv
  printf "3.5,0.23\n" >> correct_data2b.csv
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Remove first column from CSV file. \n"
printf " Expected result: Correct CSV saved. \n"

rm -f output.csv

$PROGRAM data1.csv 1 output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.csv
tacmatch correct_data1.csv output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Remove first column from TSV file. \n"
printf " Test case 2: Overwrite input data file. \n"
printf " Expected result: Correct TSV saved. \n"

cp -f data1.tsv output.tsv

$PROGRAM output.tsv 1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.tsv
tacmatch correct_data1.csv output.tsv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

cp -f data1.tsv output.tsv

$PROGRAM output.tsv 1 output.tsv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.tsv
tacmatch correct_data1.csv output.tsv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Remove 3rd column from CSV file. \n"
printf " Expected result: Correct CSV saved. \n"

rm -f output.csv

$PROGRAM data2.csv 3 output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.csv
tacmatch correct_data2a.csv output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Remove 2nd column from CSV file. \n"
printf " Expected result: Correct CSV saved. \n"

rm -f output.csv

$PROGRAM data2.csv 2 output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.csv
tacmatch correct_data2b.csv output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
