#!/bin/bash
#: Title      : test_dcmxform
#: Date       : 2018-11-11
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

LC_NUMERIC=C

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dcmxform$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n====================================================================\n"
printf "verifying that required data exists for %s\n" $PROGRAM
printf "====================================================================\n"



DCMFILE1=../dicom/f170.dcm
if [ ! -f $DCMFILE1 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi
DCMFILE2=../dicom/f30.dcm
if [ ! -f $DCMFILE2 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi

if [ ! -f xform1.tsv ]; then
  printf "%f\t%f\t%f\t%f\n" -0.776383 0.0 0.0 49.3003  > xform1.tsv
  printf "%f\t%f\t%f\t%f\n" 0.0 -0.776383 0.0 49.3003 >> xform1.tsv
  printf "%f\t%f\t%f\t%f\n" 0.0 0.0 0.796 54.924      >> xform1.tsv
  printf "nan\tnan\tnan\tnan\n" >> xform1.tsv
fi

if [ ! -f quatern1.ift ]; then
  printf "quatern_b := %f\n" 0.0       > quatern1.ift
  printf "quatern_c := %f\n" 0.0      >> quatern1.ift
  printf "quatern_d := %f\n" 0.0      >> quatern1.ift
  printf "qoffset_x := %f\n" -49.3003 >> quatern1.ift
  printf "qoffset_y := %f\n" -49.3003 >> quatern1.ift
  printf "qoffset_z := %f\n" 54.924   >> quatern1.ift
fi

if [ ! -f xform2.tsv ]; then
  printf "%f\t%f\t%f\t%f\n" 1.30208 0.0 0.0 -124.349  > xform2.tsv
  printf "%f\t%f\t%f\t%f\n" 0.0 1.30208 0.0 -124.349 >> xform2.tsv
  printf "%f\t%f\t%f\t%f\n" 0.0 0.0 3.27 -133.58  >> xform2.tsv
  printf "nan\tnan\tnan\tnan\n" >> xform2.tsv
fi

if [ ! -f quatern2.ift ]; then
  printf "quatern_b := %f\n" 0.0      > quatern2.ift
  printf "quatern_c := %f\n" 0.0     >> quatern2.ift
  printf "quatern_d := %f\n" 1.0     >> quatern2.ift
  printf "qoffset_x := %f\n" 124.349 >> quatern2.ift
  printf "qoffset_y := %f\n" 124.349 >> quatern2.ift
  printf "qoffset_z := %f\n" -133.58 >> quatern2.ift
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: List xform with default settings. \n"
printf " Expected result: Correct values are listed. \n\n"

rm -f output1.tsv

$PROGRAM $DCMFILE1 > output1.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cat output1.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.00001 -rel=0.01 xform1.tsv output1.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: List xform with default settings. \n"
printf " Expected result: Correct values are listed. \n\n"

rm -f output2.tsv

$PROGRAM $DCMFILE2 > output2.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cat output2.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.00001 -rel=0.01 xform2.tsv output2.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: List quatern only. \n"
printf " Expected result: Correct values are listed. \n\n"

rm -f output1.ift

$PROGRAM -quatern=y -xform=n $DCMFILE1 > output1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cat output1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftmatch -abs=0.001 quatern1.ift output1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: List quatern only. \n"
printf " Expected result: Correct values are listed. \n\n"

rm -f output2.ift

$PROGRAM -quatern=y -xform=n $DCMFILE2 > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cat output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftmatch -abs=0.001 quatern2.ift output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

