#!/bin/bash
#: Title      : test_dcftime
#: Date       : 2018-05-27
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dcftime$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Valid isotope, dates, and times. \n"
printf " Expected result: Correct decay correction factor reported. \n\n"

rm -f output.txt
printf "time[min]\tDCF\n" > correct.dat
printf "20.4\t2.0\n"     >> correct.dat

$PROGRAM C-11 2018-05-27 12:00:00 2018-05-27 12:20:24 > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.01 correct.dat output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Use option -title=no to add second factor. \n"
printf " Expected result: 2nd decay correction factor added wo second title. \n\n"

printf "40.8\t4.0\n"     >> correct.dat

$PROGRAM -title=no C-11 2018-05-27 12:00:00 2018-05-27 12:40:48 >> output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.01 correct.dat output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Repeat the same but do not give 2nd date. \n"
printf " Expected result: Correct times and decay correction factors reported. \n\n"

rm -f output.txt

$PROGRAM C-11 2018-05-27 12:00:00 12:20:24 > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -title=no C-11 2018-05-27 12:00:00 12:40:48 >> output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.01 correct.dat output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Repeat the same but do not give dates at all. \n"
printf " Expected result: Correct times and decay correction factors reported. \n\n"

rm -f output.txt

$PROGRAM C-11 12:00:00 12:20:24 > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -title=no C-11 12:00:00 12:40:48 >> output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.01 correct.dat output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Valid isotope, different dates. \n"
printf " Expected result: Correct decay correction factor reported. \n\n"

rm -f output.txt
printf "time[min]\tDCF\n" > correct2.dat
printf "4704\t2.0\n"     >> correct2.dat

$PROGRAM Zr-89 2018-05-20 12:00:00 2018-05-23 18:24:00 > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.01 correct2.dat output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

