#!/bin/bash
#: Title      : test_iftadd
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftadd$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f test1.tac ]; then
  printf "1   1    2\n" >  test1.tac
  printf "2   2    3\n" >> test1.tac
  printf "3   3    4\n" >> test1.tac
  printf "4   4    5\n" >> test1.tac
  printf "# timeunit := sec\n" >> test1.tac
  printf "# unit := Bq/cc\n" >> test1.tac
  printf "# studynr := test1\n" >> test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.tac ]; then
  printf "1   1    2\n" >  test2.tac
  printf "2   2    3\n" >> test2.tac
  printf "3   3    4\n" >> test2.tac
  printf "4   4    5\n" >> test2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f toadd1.ift ]; then
  printf "patient_name := Charlie Brown    \n" >  toadd1.ift
  printf "patient_name := Kustaa Yliniitty \n" >> toadd1.ift
  printf "patient_name := Vesa Oikonen     \n" >> toadd1.ift
  printf "calibrated := yes                \n" >> toadd1.ift
  printf "calibration_date := 2005-12-14   \n" >> toadd1.ift
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f lorem.txt ]; then
  printf "Lorem ipsum dolor sit amet, consectetur adipisicing \n" >  lorem.txt
  printf "elit, sed do eiusmod tempor incididunt ut labore et \n" >> lorem.txt
  printf "dolore magna aliqua. Ut enim ad minim veniam, quis \n" >> lorem.txt
  printf "nostrud exercitation ullamco laboris nisi ut aliquip \n" >> lorem.txt
  printf "ex ea commodo consequat. Duis aute irure dolor in \n" >> lorem.txt
  printf "reprehenderit in voluptate velit esse cillum dolore \n" >> lorem.txt
  printf "eu fugiat nulla pariatur. Excepteur sint occaecat \n" >> lorem.txt
  printf "cupidatat non proident, sunt in culpa qui officia \n" >> lorem.txt
  printf "deserunt mollit anim id est laborum. \n" >> lorem.txt
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Creating new file with selected item from another file. \n"
printf " Expected result: File created, containing just that item. \n\n"

rm -f temp.ift output.ift
printf "calibration_date := 2005-12-14\n" > temp.ift

$PROGRAM output.ift toadd1.ift calibration_date 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "calibration_date" "2005-12-14"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch temp.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Trying to add item but key does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM output.ift toadd1.ift badkey 1>stdout.txt 2>&1 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "key not found."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case: Adding two keys, one of which does not exist. \n"
printf " Expected result 1: Items with existing key is added. \n"
printf " Expected result 2: Warning about nonmatching key. \n\n"

$PROGRAM output.ift toadd1.ift calibrated badkey patient_name 1>stdout.txt 2>&1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Warning" "key 'badkey' was not found."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case: No keys are given. \n"
printf " Expected result: All items are added. \n\n"

rm -f output.ift

$PROGRAM output.ift toadd1.ift  
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Adding item with key that exists already. \n"
printf " Test case 2: Option -ovr. \n"
printf " Expected result: Items with existing key are replaced by the new one. \n\n"

cp -f toadd1.ift output.ift
printf "patient_name := Elmer Etukeno\n" > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM -ovr output.ift temp.ift patient_name 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.ift temp.ift patient_name
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftmatch output.ift toadd1.ift patient_name
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Adding item with key that exists already. \n"
printf " Test case 2: Option -nodupl. \n"
printf " Expected result 1: Item is not added, file is not modified. \n"
printf " Expected result 2: Error. \n\n"

cp -f toadd1.ift output.ift
printf "patient_name := Elmer Etukeno\n" > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM -nodupl output.ift temp.ift patient_name 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.ift toadd1.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Error" "no items could be inserted."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Adding new item and item with key that exists already. \n"
printf " Test case 2: Option -nodupl. \n"
printf " Expected result 1: Existing item is not added, with warning. \n"
printf " Expected result 2: New item is added. \n\n"

cp -f toadd1.ift output.ift
printf "patient_name := Elmer Etukeno\n" > temp.ift
printf "tauti := nuha\n"                >> temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM -nodupl output.ift temp.ift patient_name tauti 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "existing key 'patient_name' not added."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftmatch output.ift temp.ift tauti
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case 1: Adding new item and item with key that exists already. \n"
printf " Test case 2: No options. \n"
printf " Expected result 1: All items are added. \n"
printf " Expected result 2: Old items are kept. \n\n"

cp -f toadd1.ift output.ift
printf "patient_name := Elmer Etukeno\n" > temp.ift
printf "tauti := nuha\n"                >> temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
cp -f toadd1.ift temp2.ift
cat temp.ift >> temp2.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM output.ift temp.ift patient_name tauti 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.ift temp2.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"

printf "\n 2.0.0 \n"
printf " Test case: Trying to add item from file that is not IFT at all. \n"
printf " Expected result 1: Error. \n"
printf " Expected result 2: Output file is not modified. \n"

cp -f toadd1.ift output.ift

$PROGRAM output.ift lorem.txt patient_name 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.ift toadd1.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Error" "key not found."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Trying to add all contents from file that is not IFT at all. \n"
printf " Expected result 1: Error. \n"
printf " Expected result 2: Output file is not modified. \n"

cp -f toadd1.ift output.ift

$PROGRAM output.ift lorem.txt 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.ift toadd1.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Error" "no items could be inserted."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Adding items into non IFT file. \n"
printf " Expected result: Non-IFT lines are deleted. \n\n"

cp -f lorem.txt output.ift

$PROGRAM output.ift toadd1.ift 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.ift toadd1.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case: Adding items into TAC file. \n"
printf " Expected result: Non-IFT lines are deleted. \n\n"

cp -f test2.tac output.tac

$PROGRAM output.tac test1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch output.tac test1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
tacmatch output.tac test1.tac
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
