#!/bin/bash
#: Title      : test_iftdel
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftdel$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f test1.tac ]; then
  printf "1   1    2\n" >  test1.tac
  printf "2   2    3\n" >> test1.tac
  printf "3   3    4\n" >> test1.tac
  printf "4   4    5\n" >> test1.tac
  printf "# timeunit := sec\n" >> test1.tac
  printf "# unit := Bq/cc\n" >> test1.tac
  printf "# studynr := test1\n" >> test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.tac ]; then
  printf "1   1    2\n" >  test2.tac
  printf "2   2    3\n" >> test2.tac
  printf "3   3    4\n" >> test2.tac
  printf "4   4    5\n" >> test2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f toadd1.ift ]; then
  printf "patient_name := Charlie Brown    \n" >  toadd1.ift
  printf "patient_name := Kustaa Yliniitty \n" >> toadd1.ift
  printf "patient_name := Vesa Oikonen     \n" >> toadd1.ift
  printf "calibrated := yes                \n" >> toadd1.ift
  printf "calibration_date := 2005-12-14   \n" >> toadd1.ift
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f lorem.txt ]; then
  printf "Lorem ipsum dolor sit amet, consectetur adipisicing \n" >  lorem.txt
  printf "elit, sed do eiusmod tempor incididunt ut labore et \n" >> lorem.txt
  printf "dolore magna aliqua. Ut enim ad minim veniam, quis \n" >> lorem.txt
  printf "nostrud exercitation ullamco laboris nisi ut aliquip \n" >> lorem.txt
  printf "ex ea commodo consequat. Duis aute irure dolor in \n" >> lorem.txt
  printf "reprehenderit in voluptate velit esse cillum dolore \n" >> lorem.txt
  printf "eu fugiat nulla pariatur. Excepteur sint occaecat \n" >> lorem.txt
  printf "cupidatat non proident, sunt in culpa qui officia \n" >> lorem.txt
  printf "deserunt mollit anim id est laborum. \n" >> lorem.txt
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Delete an item with specified key. \n"
printf " Expected result: Item deleted, other items intact. \n\n"

cp -f toadd1.ift output.ift
printf "scan_date := 2005-12-13\n" >> output.ift

$PROGRAM output.ift scan_date 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Delete all items with specified key. \n"
printf " Expected result: Items deleted, other items intact. \n\n"

cp -f toadd1.ift output.ift

$PROGRAM output.ift patient_name 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift patient_name
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftmatch toadd1.ift output.ift calibrated 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift calibration_date
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Deleting several keys at once. \n"
printf " Expected result: Items deleted, other items intact. \n\n"

cp -f toadd1.ift output.ift
rm -f temp.ift
iftadd temp.ift toadd1.ift patient_name
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM output.ift calibrated calibration_date
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch temp.ift output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case: Trying to delete all keys. \n"
printf " Expected result: Error, file not modified. \n\n"

cp -f toadd1.ift output.ift

$PROGRAM output.ift calibrated calibration_date patient_name 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Error" "all items would be removed."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Try to delete item when key does not exist. \n"
printf " Expected result: Error, file not modified. \n\n"

cp -f toadd1.ift output.ift

$PROGRAM output.ift badkey 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Error" "key not found."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: One item found, another not. \n"
printf " Expected result 1: Existing item deleted. \n"
printf " Expected result 2: Warning about the one not found. \n\n"

cp -f toadd1.ift output.ift

$PROGRAM output.ift badkey patient_name 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch toadd1.ift output.ift 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Warning" "key 'badkey' was not found."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case: Item deleted from TAC file. \n"
printf " Expected result 1: Item deleted. \n"
printf " Expected result 2: Also TAC data deleted. \n\n"

cp -f test1.tac output.tac

$PROGRAM output.tac timeunit 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.tac timeunit
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
tacmatch test1.tac output.tac
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
