#!/bin/bash
#: Title      : test_iftedit
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftedit$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

#printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f test1.tac ]; then
  printf "1   1    2\n" >  test1.tac
  printf "2   2    3\n" >> test1.tac
  printf "3   3    4\n" >> test1.tac
  printf "4   4    5\n" >> test1.tac
  printf "# timeunit := sec\n" >> test1.tac
  printf "# unit := Bq/cc\n" >> test1.tac
  printf "# studynr := test1\n" >> test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.par ]; then
  printf "# program := perfrat 0.7.1 (c) 2018 by Turku PET Centre\n" > test2.par
  printf "# analysis_time := 2019-02-28 12:04:53\n"                 >> test2.par
  printf "Parameters	PR[unitless]	Start[min]	End[min]\n" >> test2.par
  printf "cortex	1.06315	0	0.3\n"                      >> test2.par
  printf "medulla	0.70723	0	2.5\n"                      >> test2.par
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test3.ift ]; then
  printf "patient_name := Charlie Brown    \n" >  test3.ift
  printf "patient_name := Kustaa Yliniitty \n" >> test3.ift
  printf "patient_name := Vesa Oikonen     \n" >> test3.ift
  printf "calibrated := yes                \n" >> test3.ift
  printf "calibration_date := 2005-12-14   \n" >> test3.ift
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f lorem.txt ]; then
  printf "Lorem ipsum dolor sit amet, consectetur adipisicing \n" >  lorem.txt
  printf "elit, sed do eiusmod tempor incididunt ut labore et \n" >> lorem.txt
  printf "dolore magna aliqua. Ut enim ad minim veniam, quis \n" >> lorem.txt
  printf "nostrud exercitation ullamco laboris nisi ut aliquip \n" >> lorem.txt
  printf "ex ea commodo consequat. Duis aute irure dolor in \n" >> lorem.txt
  printf "reprehenderit in voluptate velit esse cillum dolore \n" >> lorem.txt
  printf "eu fugiat nulla pariatur. Excepteur sint occaecat \n" >> lorem.txt
  printf "cupidatat non proident, sunt in culpa qui officia \n" >> lorem.txt
  printf "deserunt mollit anim id est laborum. \n" >> lorem.txt
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Rename value in TAC comment line. \n"
printf " Expected result: File correctly edited. \n\n"

cp -f test1.tac temp.tac

$PROGRAM temp.tac unit Bq/mL 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.tac "unit" "Bq/mL"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test1.tac temp.tac timeunit
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test1.tac temp.tac studynr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=1 -yunit=n test1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Add study number into parameter file. \n"
printf " Expected result: File correctly edited. \n\n"

cp -f test2.par temp.par

$PROGRAM temp.par studynr tg2 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.par "studynr" "tg2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 test2.par temp.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Edit study number in parameter file. \n"
printf " Expected result: File correctly edited. \n\n"

$PROGRAM temp.par studynr tg2r35
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.par "studynr" "tg2r35"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 test2.par temp.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.2 \n"
printf " Test case: remove study number from parameter file. \n"
printf " Expected result: File correctly edited. \n\n"

$PROGRAM temp.par studynr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.par "studynr"
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 test2.par temp.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: IFT file contains several equal key names. \n"
printf " Expected result: first is edited and the rest are deleted. \n\n"

cp -f test3.ift temp.ift

$PROGRAM temp.ift patient_name name1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift "patient_name" "name1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift "patient_name" "Kustaa Yliniitty"
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift "patient_name" "Vesa Oikonen"
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test3.ift temp.ift calibrated
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test3.ift temp.ift calibration_date
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Text file has no key names. \n"
printf " Expected result: error. \n"

cp -f lorem.txt temp.txt

$PROGRAM temp.txt "" value
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.txt keyname 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Note "file contains no key 'keyname'"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case: Neither of the keys are given. \n"
printf " Expected result: Error. \n\n"

cp -f test3.ift temp.ift

$PROGRAM temp.ift
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.ift "" ""
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.ift '' ''
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
