#!/bin/bash
#: Title      : test_iftmatch
#: Date       : 2016-02-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftmatch$EXT;

printf "\n====================================================================\n"
printf "verifying that required data exists for %s\n" $PROGRAM
printf "====================================================================\n"


if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f test1a.ift ] || [ ! -f test1b.ift ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test2a.ift ] || [ ! -f test2b.ift ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test2c.ift ] || [ ! -f test2d.ift ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test3a.ift ] || [ ! -f test3b.ift ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test3c.ift ] || [ ! -f test3d.ift ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n1.0.0\n"

printf "Testing file against itself should pass\n"
$PROGRAM -d test1a.ift test1a.ift
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.1\n"

printf "Testing file against itself should pass with existing key\n"
$PROGRAM -d test1a.ift test1a.ift text1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.2\n"

printf "Testing file against itself should fail with nonexisting key\n"
$PROGRAM -d test1a.ift test1a.ift nonexistingkey
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.1.0\n"

printf "Different key nr should lead to failed match\n"
$PROGRAM -d test1a.ift test1b.ift
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.1.1\n"

printf "Different key nr should still pass with correct key\n"
$PROGRAM -d test1a.ift test1b.ift text1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.1.2\n"

printf "Empty value in both files should pass\n"
$PROGRAM -d test1a.ift test1b.ift text2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.0\n"

printf "Same value should match even if it does not match as a string\n"
$PROGRAM -d test1a.ift test1b.ift value3
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.1\n"

printf "Less than test works with key\n"
$PROGRAM -d -lt test1a.ift test1b.ift value2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.2\n"

printf "Greater than test works with key\n"
$PROGRAM -d -gt test1a.ift test1b.ift value1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.3\n"

printf "Abs diff test works with key\n"
$PROGRAM -d -abs=0.3 test1a.ift test1b.ift value1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d -abs=0.003 test1a.ift test1b.ift value1
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "=== Testing data with multiple instances of the same key values =====\n"

printf "\n2.0.0\n"

printf "Passed when values are the same and key nr matches\n"
$PROGRAM -d test2a.ift test2b.ift value1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n2.0.1\n"

printf "not passed even when values are the same, if key nr does not match\n"
$PROGRAM -d test2a.ift test2b.ift value2
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n2.0.2\n"

printf "or if values are not in the same order\n"
$PROGRAM -d test2a.ift test2d.ift value2
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n2.1.0\n"

printf "passes without key if values are the same\n"
$PROGRAM -d test2a.ift test2c.ift
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n2.1.1\n"

printf "but not if key nr is not the same\n"
$PROGRAM -d test2a.ift test2b.ift
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n2.1.2\n"

printf "nor if values are in different order\n"
$PROGRAM -d test2a.ift test2d.ift
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "=== Testing data with two different key names =====\n"

printf "\n3.0.0\n"

printf "two key names with matching values\n"
$PROGRAM -d test3a.ift test3b.ift value1 walue1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.0.1\n"

printf "two key names with matching values and two instances\n"
$PROGRAM -d test3a.ift test3b.ift value5 walue5
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.0.2\n"

printf "two key names with nonmatching values\n"
$PROGRAM -d test3a.ift test3b.ift value1 walue2
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.1.0\n"

printf "two key names with matching values inside one file\n"
$PROGRAM -d test3a.ift test3a.ift x y
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.1.1\n"

printf "two key names with nonmatching values inside one file\n"
$PROGRAM -d test3a.ift test3a.ift x z
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.1.2\n"

printf "two key names with nonmatching values inside one file with -abs\n"
$PROGRAM -d -abs=0,1 test3a.ift test3a.ift x z
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.1.3\n"

printf "two key names with nonmatching values inside one file with -lt\n"
$PROGRAM -d -lt test3a.ift test3a.ift x z
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d -lt test3a.ift test3a.ift z y
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.1.4\n"

printf "two key names with nonmatching values inside one file with -gt\n"
$PROGRAM -d -gt test3a.ift test3a.ift z x
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d -gt test3a.ift test3a.ift x z
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "=== Testing data with units =====\n"

printf "\n3.2.0\n"

printf "two key names with matching values but with and without units\n"
$PROGRAM -d test3a.ift test3d.ift value1 walue1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.2.1\n"

printf "two key names with matching values and two instances\n"
$PROGRAM -d test3a.ift test3d.ift value5 walue5
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.2.2\n"

printf "two key names with nonmatching values\n"
$PROGRAM -d test3a.ift test3d.ift value1 walue2
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.3.0\n"

printf "two key names with matching values inside one file\n"
$PROGRAM -d test3c.ift test3c.ift x y
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.3.1\n"

printf "two key names with nonmatching values inside one file\n"
$PROGRAM -d test3c.ift test3c.ift x z
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.3.2\n"

printf "two key names with nonmatching values inside one file with -abs\n"
$PROGRAM -d -abs=0,1 test3c.ift test3c.ift x z
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.3.3\n"

printf "two key names with nonmatching values inside one file with -lt\n"
$PROGRAM -d -lt test3c.ift test3c.ift x z
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d -lt test3c.ift test3c.ift z y
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n3.3.4\n"

printf "two key names with nonmatching values inside one file with -gt\n"
$PROGRAM -d -gt test3c.ift test3c.ift z x
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d -gt test3c.ift test3c.ift x z
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
