#!/bin/bash
#: Title      : test_iftren
#: Date       : 2018-01-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftren$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f test1.tac ]; then
  printf "1   1    2\n" >  test1.tac
  printf "2   2    3\n" >> test1.tac
  printf "3   3    4\n" >> test1.tac
  printf "4   4    5\n" >> test1.tac
  printf "# timeunit := sec\n" >> test1.tac
  printf "# unit := Bq/cc\n" >> test1.tac
  printf "# studynr := test1\n" >> test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test3.ift ]; then
  printf "patient_name := Charlie Brown    \n" >  test3.ift
  printf "patient_name := Kustaa Yliniitty \n" >> test3.ift
  printf "patient_name := Vesa Oikonen     \n" >> test3.ift
  printf "calibrated := yes                \n" >> test3.ift
  printf "calibration_date := 2005-12-14   \n" >> test3.ift
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f lorem.txt ]; then
  printf "Lorem ipsum dolor sit amet, consectetur adipisicing \n" >  lorem.txt
  printf "elit, sed do eiusmod tempor incididunt ut labore et \n" >> lorem.txt
  printf "dolore magna aliqua. Ut enim ad minim veniam, quis \n" >> lorem.txt
  printf "nostrud exercitation ullamco laboris nisi ut aliquip \n" >> lorem.txt
  printf "ex ea commodo consequat. Duis aute irure dolor in \n" >> lorem.txt
  printf "reprehenderit in voluptate velit esse cillum dolore \n" >> lorem.txt
  printf "eu fugiat nulla pariatur. Excepteur sint occaecat \n" >> lorem.txt
  printf "cupidatat non proident, sunt in culpa qui officia \n" >> lorem.txt
  printf "deserunt mollit anim id est laborum. \n" >> lorem.txt
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Rename key in comment line. \n"
printf " Expected result: File correctly edited. \n\n"

cp -f test1.tac temp.tac

$PROGRAM temp.tac unit calibration_unit 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.tac "calibration_unit" "Bq/cc"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test1.tac temp.tac timeunit
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test1.tac temp.tac studynr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.0 \n"
printf " Test case: File contains several equal key names. \n"
printf " Expected result: Key names can be renamed one at a time. \n\n"

cp -f test3.ift temp.ift

$PROGRAM temp.ift patient_name name1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.ift patient_name name2 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.ift patient_name name3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift "name1" "Charlie Brown"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift "name2" "Kustaa Yliniitty"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift "name3" "Vesa Oikonen"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test3.ift temp.ift calibrated
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test3.ift temp.ift calibration_date
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.0 \n"
printf " Test case: Text file has no key names. \n"
printf " Expected result: Each line can be given its own key name one at a time. \n"
printf " Expected result2: Error when no more missing key names. \n\n"

cp -f lorem.txt temp.txt

$PROGRAM temp.txt "" line1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line2 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line5
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line6
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line7
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.txt "" line9
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.txt "" line10
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval temp.txt line2 "elit, sed do eiusmod tempor incididunt ut labore et"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Remove key names. \n"
printf " Expected result: File without specified key names is saved. \n\n"


cp -f test1.tac temp.tac

$PROGRAM temp.tac "" line1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.tac "" line2
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.tac "" line3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.tac "" line4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.tac line1 ""
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.tac line2 ""
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.tac line3 ""
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.tac line4 ""
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch test1.tac temp.tac 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch test1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case: Neither of the keys are given. \n"
printf " Expected result: Error. \n\n"

cp -f test3.ift temp.ift

$PROGRAM temp.ift
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.ift "" ""
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.ift '' ''
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
