#!/bin/bash
#: Title      : test_niinan
#: Date       : 2023-03-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../niinan$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f test.tac ]; then
  rm -f test.nii
  printf "\n creating test.tac \n"
  printf "start[seconds]	end	Mask-1	Mask-2	Mask-3	Mask-4	Mask-5	Mask-6	Mask-7	Mask-8	Mask-9\n" > test.tac
  printf "0.0	60	1	2	3	4	5	6	7	8	9\n" >> test.tac
  printf "120	240	-2	-1	0	1	2	3	4	5	6\n" >> test.tac
fi

if [ ! -f testna.tac ]; then
  rm -f testna.nii
  printf "\n creating testna.tac \n"
  printf "start[seconds]	end[Bq/cc]	Mask-1	Mask-2	Mask-3	Mask-4	Mask-5	Mask-6	Mask-7	Mask-8	Mask-9\n" > testna.tac
  printf "0.0	60	1	2	3	4	5	6	7	8	9\n" >> testna.tac
  printf "120	240	-2	-1	.	1	2	3	4	5	6\n" >> testna.tac
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Image does/ does not not have missing values. \n"
printf " Expected result: Correctly reported. \n\n"

rm -f output.txt
tac2nii --silent test.tac 4 4 4 test template
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM test.nii > output.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt missing_pixel_values 0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f output.txt
tac2nii --silent testna.tac 4 4 4 testna template
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM testna.nii > output.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt missing_pixel_values 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n 1.1.0 \n"
printf " Test case: Option -fix to put zeroes instead of missing values. \n"
printf " Expected result 1: Missing values correctly reported. \n"
printf " Expected result 2: Correct result image. \n\n"

$PROGRAM -fix testna.nii > output.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt missing_pixel_values 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft testna.nii template.nii output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch test.nii testna.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM -fix testna.nii > output.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt missing_pixel_values 0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch test.nii testna.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
