#!/bin/bash
#: Title      : test_injdifft
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../injdifft$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f test1.ift ]; then
  printf "filename := test1.v                    \n" >  test1.ift
  printf "scan_start_time := 2006-01-04 16:06:54 \n" >> test1.ift
fi
if [ ! -f test2.ift ]; then
  printf "filename := test2.v                    \n" >  test2.ift
  printf "scan_start_time := 2006-01-04 16:07:00 \n" >> test2.ift
fi
if [ ! -f test1_err.ift ]; then
  printf "filename := test1.v                    \n" >  test1_err.ift
  printf "scan_start := 2006-01-04 16:06:54      \n" >> test1_err.ift
fi
if [ ! -f test2_err.ift ]; then
  printf "filename := test2.v                    \n" >  test2_err.ift
  printf "scan_time := 2006-01-04 16:07:00       \n" >> test2_err.ift
fi
if [ ! -f test1_err2.ift ]; then
  printf "filename := test1.v                     \n" >  test1_err2.ift
  printf "scan_start_time := 20006-01-04 16:06:54 \n" >> test1_err2.ift
fi
if [ ! -f test2_err2.ift ]; then
  printf "filename := test2.v                     \n" >  test2_err2.ift
  printf "scan_start_time := 2006-01-04           \n" >> test2_err2.ift
fi

if [ ! -f test3.ift ]; then
  printf "filename := test1.v                    \n" >  test3.ift
  printf "injection_time := 1997-06-27 10:01:04  \n" >> test3.ift
fi
if [ ! -f test4.ift ]; then
  printf "filename := test2.v                    \n" >  test4.ift
  printf "injection_time := 1997-06-28 12:07:00  \n" >> test4.ift
fi

if [ ! -f test5a.ift ]; then
  printf "filename := test1.v                    \n" >  test5a.ift
  printf "injection_time := 1997-06-28 10:00:00  \n" >> test5a.ift
fi
if [ ! -f test6a.ift ]; then
  printf "filename := test2.v                    \n" >  test6a.ift
  printf "injection_time := 1997-06-28 10:58:30  \n" >> test6a.ift
fi

if [ ! -f test5b.ift ]; then
  printf "filename := test1.v                    \n" >  test5b.ift
  printf "injection_time := 1997-06-28 10:00:00  \n" >> test5b.ift
fi
if [ ! -f test6b.ift ]; then
  printf "filename := test2.v                    \n" >  test6b.ift
  printf "injection_time := 1997-06-28 10:00:57  \n" >> test6b.ift
fi

if [ ! -f test5c.ift ]; then
  printf "filename := test1.v                    \n" >  test5c.ift
  printf "injection_time := 1997-06-28 10:00:00  \n" >> test5c.ift
fi
if [ ! -f test6c.ift ]; then
  printf "filename := test2.v                    \n" >  test6c.ift
  printf "injection_time := 1997-06-28 10:00:02  \n" >> test6c.ift
fi

if [ ! -f test5e.ift ]; then
  printf "filename := test1.v                    \n" >  test5e.ift
  printf "injection_time := 2000-06-28 13:12:08  \n" >> test5e.ift
fi
if [ ! -f test6e.ift ]; then
  printf "filename := test2.v                    \n" >  test6e.ift
  printf "injection_time := 2000-06-28 15:11:53  \n" >> test6e.ift
fi

if [ ! -f test5f.ift ]; then
  printf "filename := test1.v                    \n" >  test5f.ift
  printf "injection_time := 2000-06-28 15:59:08  \n" >> test5f.ift
fi
if [ ! -f test6f.ift ]; then
  printf "filename := test2.v                    \n" >  test6f.ift
  printf "injection_time := 2000-06-28 16:00:09  \n" >> test6f.ift
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 0.1.0 \n"
printf " Test case: Non-existing input file. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistfile1.ift nonexistingfile2.ift 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Output file not given. \n"
printf " Test case 2: Field name scan_start_time. \n"
printf " Expected result 1: Output to stdout. \n"
printf " Expected result 2: Correct result. \n\n"

$PROGRAM test1.ift test2.ift 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt filename1 "test1.ift"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt filename2 "test2.ift"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt time_difference "6 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Output file given. \n"
printf " Test case 2: Field name injection_time. \n"
printf " Expected result 1: Output to given file. \n"
printf " Expected result 2: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test3.ift test4.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift filename1 "test3.ift"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift filename2 "test4.ift"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift time_difference "356 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Missing field name in file1. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test1_err.ift test2.ift 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Missing field name in file2. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test1.ift test2_err.ift 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Missing field value in file1. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test1_err2.ift test2.ift 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.3 \n"
printf " Test case: Missing field value in file2. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test1.ift test2_err2.ift 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Negative time difference. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test2.ift test1.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift filename1 "test2.ift"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift filename2 "test1.ift"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift time_difference "-6 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Time diff close to an hour. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test5a.ift test6a.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "3510 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.3.1 \n"
printf " Test case: Negative time diff close to an hour. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test6a.ift test5a.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-3510 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.4.0 \n"
printf " Test case: Time diff close to a minute. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test5b.ift test6b.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "57 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.4.1 \n"
printf " Test case: Negative time diff close to a minute. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test6b.ift test5b.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-57 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.5.0 \n"
printf " Test case: Time diff of few sec. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test5c.ift test6c.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "2 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.5.1 \n"
printf " Test case: Negative time diff of few sec. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test6c.ift test5c.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-2 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.5.2 \n"
printf " Test case: No time difference. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM test5a.ift test5a.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "0 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.6.0 \n"
printf " Test case: Time diff close to an hour with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test5a.ift test6a.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-90 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.6.1 \n"
printf " Test case: Negative time diff close to an hour with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test6a.ift test5a.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "90 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.7.0 \n"
printf " Test case: Time diff close to a minute with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test5b.ift test6b.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "57 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.7.1 \n"
printf " Test case: Negative time diff close to a minute with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test6b.ift test5b.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-57 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.8.0 \n"
printf " Test case: Time diff of few sec with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test5c.ift test6c.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "2 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.8.1 \n"
printf " Test case: Negative time diff of few sec with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test6c.ift test5c.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-2 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.8.2 \n"
printf " Test case: No time diff with option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test5a.ift test5a.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "0 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 \n"
printf " Test case: Option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test5e.ift test6e.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-15 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test6e.ift test5e.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "15 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test5f.ift test6f.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "61 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.3 \n"
printf " Test case: Option -small. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -small test6f.ift test5f.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "-61 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Option -min. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -min test1.ift test2.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "0.1 [min]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 \n"
printf " Test case: Option -sec. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.ift
$PROGRAM -sec test1.ift test2.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval output.ift time_difference "6 [s]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
