/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpctac.h"
#include "tpctacmod.h"
#include "test_tpcbfm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_bf_srtm(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  ret=bfmSRTM(NULL, NULL, 0, 0, 0, 0, NULL, NULL);
  if(verbose>1) printf("\ndid not segfault, that is good.\n");
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) printf("\n make test data\n");
  TAC ref; tacInit(&ref); if(create_ref(&ref)) {tacFree(&ref); return(2);}
  double cri[ref.sampleNr];
  if(liIntegratePET(ref.x1, ref.x2, ref.c[0].y, ref.sampleNr, cri, NULL, 0)) {
    tacFree(&ref); return(3);
  }

  if(verbose>1) printf("\n compute basis functions\n");
  TAC bf; tacInit(&bf);
  ret=bfmSRTM(ref.x, cri, ref.sampleNr, 10, 0.02, 0.10, &bf, status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "ret := %s\n", errorMsg(status->error));
    tacFree(&ref); tacFree(&bf); return(11);
  }
  if(bf.sampleNr!=ref.sampleNr || bf.tacNr!=10) {
    tacFree(&ref); tacFree(&bf); return(12);
  }
  ret=tacPlotLineSVG(&bf, "Basis functions for SRTM", 
                 nan(""), nan(""), nan(""), nan(""),
                 "bf_srtm.svg", NULL);
  statusSet(status, __func__, __FILE__, __LINE__, ret);
  if(ret!=TPCERROR_OK) {tacFree(&ref); tacFree(&bf); return(13);}


  tacFree(&ref); tacFree(&bf);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
