/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpctac.h"
#include "test_tpcbfm.h"
/*****************************************************************************/

/*****************************************************************************/
/** Create test input TAC data */
int create_inp(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 5, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=5;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "inp%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=0.0; tac->x2[fi]=2.0;   tac->x[fi]=1.0;   tac->c[ri].y[fi]=0.0;
  fi=1; tac->x1[fi]=2.0; tac->x2[fi]=4.0;   tac->x[fi]=3.0;   tac->c[ri].y[fi]=50.0;
  fi=2; tac->x1[fi]=4.0; tac->x2[fi]=6.0;   tac->x[fi]=5.0;   tac->c[ri].y[fi]=25.0;
  fi=3; tac->x1[fi]=6.0; tac->x2[fi]=10.0;  tac->x[fi]=8.0;   tac->c[ri].y[fi]=0.0;
  fi=4; tac->x1[fi]=10.; tac->x2[fi]=190.0; tac->x[fi]=100.0; tac->c[ri].y[fi]=0.0;
  return TPCERROR_OK;
}

/** Create test tissue TAC data */
int create_tis(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 4, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=4;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "tis%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=0.0;  tac->x2[fi]=2.0;   tac->x[fi]=1.0;  tac->c[ri].y[fi]=0.0;
  fi=1; tac->x1[fi]=2.0;  tac->x2[fi]=4.0;   tac->x[fi]=3.0;  tac->c[ri].y[fi]=5.0;
  fi=2; tac->x1[fi]=4.0;  tac->x2[fi]=10.0;  tac->x[fi]=7.0;  tac->c[ri].y[fi]=3.0;
  fi=3; tac->x1[fi]=10.0; tac->x2[fi]=20.0;  tac->x[fi]=15.0; tac->c[ri].y[fi]=1.0;
  return TPCERROR_OK;
}

/** Create test reference tissue TAC data */
int create_ref(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 4, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=4;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "ref%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=0.0;  tac->x2[fi]=2.0;   tac->x[fi]=1.0;  tac->c[ri].y[fi]=0.0;
  fi=1; tac->x1[fi]=2.0;  tac->x2[fi]=4.0;   tac->x[fi]=3.0;  tac->c[ri].y[fi]=50.0;
  fi=2; tac->x1[fi]=4.0;  tac->x2[fi]=10.0;  tac->x[fi]=7.0;  tac->c[ri].y[fi]=10.0;
  fi=3; tac->x1[fi]=10.0; tac->x2[fi]=20.0;  tac->x[fi]=15.0; tac->c[ri].y[fi]=5.0;
  return TPCERROR_OK;
}
/*****************************************************************************/

/*****************************************************************************/
