/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpctac.h"
#include "test_tpccm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_simC2(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }


  int ret;
  TAC input, tissue, correct;
  tacInit(&input); tacInit(&tissue); tacInit(&correct);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=simC2(NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(verbose>3) printf("  ret=%d\n", ret);
  if(ret==0) return(1);
  if(verbose>2) printf("\n more testing with empty data \n");
  ret=simC2(NULL, NULL, 100, 0.2, 0.4, 0.0, 0.0, NULL, NULL, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(verbose>3) printf("  ret=%d\n", ret);
  if(ret==0) return(2);
  if(verbose>2) printf("\n more testing with empty data \n");
  ret=simC2(input.x, input.x, 0, 0.2, 0.4, 0.1, 0.1, NULL, NULL, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(verbose>3) printf("  ret=%d\n", ret);
  if(ret==0) return(3);

  if(verbose>1) printf("\n testing with data made in spreadsheet \n");
  ret=tacRead(&input, "input.dat", status);
  if(ret==TPCERROR_OK) ret=tacRead(&correct, "ct_2tcm.dat", status);
  if(ret!=TPCERROR_OK) {
    printf("Error: cannot read test data; run test in 'test' directory.\n");
    tacFree(&input); tacFree(&tissue); tacFree(&correct); return 10;
  }
  tacDuplicate(&input, &tissue);
  ret=simC2(input.x, input.c[0].y, input.sampleNr, 0.4, 0.5, 0.4, 0.3, 
            tissue.c[0].y, NULL, NULL);
  if(ret!=0) {
    tacFree(&input); tacFree(&tissue); tacFree(&correct); return 11;
  }
  ret=tacCompareConc(&correct, &tissue, 0, 0.001, 0.001, status);
  if(ret!=0) {
    tacFree(&input); tacFree(&tissue); tacFree(&correct); return 12;
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&input); tacFree(&tissue); tacFree(&correct);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_simC2_i(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }


  int ret;
  TAC input, tissue, correct;
  tacInit(&input); tacInit(&tissue); tacInit(&correct);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=simC2_i(NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(verbose>3) printf("  ret=%d\n", ret);
  if(ret==0) return(1);
  if(verbose>2) printf("\n more testing with empty data \n");
  ret=simC2_i(NULL, NULL, 100, 0.2, 0.4, 0.0, 0.0, NULL, NULL, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(verbose>3) printf("  ret=%d\n", ret);
  if(ret==0) return(2);
  if(verbose>2) printf("\n more testing with empty data \n");
  ret=simC2_i(input.x, input.x, 0, 0.2, 0.4, 0.1, 0.1, NULL, NULL, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(verbose>3) printf("  ret=%d\n", ret);
  if(ret==0) return(3);

  if(verbose>1) printf("\n testing with data made in spreadsheet \n");
  ret=tacRead(&input, "input_integral.dat", status);
  if(ret==TPCERROR_OK) ret=tacRead(&correct, "ct_2tcm.dat", status);
  if(ret!=TPCERROR_OK) {
    printf("Error: cannot read test data; run test in 'test' directory.\n");
    tacFree(&input); tacFree(&tissue); tacFree(&correct); return 10;
  }
  tacDuplicate(&input, &tissue);
  ret=simC2_i(input.x, input.c[0].y, input.sampleNr, 0.4, 0.5, 0.4, 0.3, 
              tissue.c[0].y, NULL, NULL);
  if(ret!=0) {
    tacFree(&input); tacFree(&tissue); tacFree(&correct); return 11;
  }
  ret=tacCompareConc(&correct, &tissue, 0, 0.001, 0.001, status);
  if(ret!=0) {
    tacFree(&input); tacFree(&tissue); tacFree(&correct); return 12;
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&input); tacFree(&tissue); tacFree(&correct);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
