/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcli.h"
#include "test_tpccm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_simOxygen(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("\ntesting with invalid input\n");
  ret=simOxygen(NULL, NULL, NULL, NULL, NULL, 0,
                0.1, 0.1, 0.1, 0.1, 0.1, 0.04, 0.30, 0,
                NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, verbose-2);
  if(ret==0) return(1);
  ret=simOxygen(NULL, NULL, NULL, NULL, NULL, 100,
                0.1, 0.1, 0.1, 0.1, 0.1, 0.04, 0.30, 0,
                NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, verbose-2);
  if(ret==0) return(2);

  if(verbose>1) printf("\nMaking step function data for testing\n");
  int i, n=200;
  double buf[6*n];
  double *x=buf;
  double *y1=x+n;
  double *y2=y1+n;
  double *y3=y2+n;
  double *sy1=y3+n;
  double *yi=sy1+n;
  double auc1, auc2, sauc1, f;
  for(i=0; i<n; i++) {x[i]=y1[i]=y2[i]=y3[i]=sy1[i]=0.0;}
  i=1; x[i]=(double)i;
  for(++i; i<13; i++) {x[i]=(double)(i-1); y1[i]=10.0; y2[i]=5.0;}
  for(; i<n; i++) x[i]=(double)(i-2);
  liIntegrate(x, y1, n, yi, 0, verbose-5); auc1=yi[n-1]; 
  if(0) {
    printf("X\tY1\tY2\tY3\n");
    for(i=0; i<n; i++) printf("%g\t%g\t%g\t%g\n", x[i], y1[i], y2[i], y3[i]);
    printf("\n auc1=%g auc2=%g\n", auc1, auc2);
    printf("\n");
  }

  if(verbose>1) {
    printf("\ntesting with tracer1=tracer2\n");
    printf("in this situation, VT=(k1a/(k2a+km))*(1+(km/k2b))+(k1b/k2b) \n");
  }
  ret=simOxygen(x, y1, y1, NULL, NULL, n,
                0.4, 0.2, 0.1, 0.2, 0.2, 0.0, 0.0, 0,
                sy1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, verbose-2);
  if(ret!=0) return(101);
  if(0) {
    printf("X\tY1\tY2\tSY1\n");
    for(i=0; i<n; i++) printf("%g\t%g\t%g\t%g\n", x[i], y1[i], y1[i], sy1[i]);
    printf("\n");
  }
  liIntegrate(x, sy1, n, yi, 0, verbose-5); sauc1=yi[n-1]; f=sauc1/auc1; 
  if(verbose>2) {
    printf("input auc=%g ; output auc=%g ; output/input=%g\n", auc1, sauc1, f);
  }
  if(!doubleMatch(3.0, f, 0.001)) return(102);


  if(verbose>1) {
    printf("\ntesting with tracer1, km=0, tracer2=0\n");
    printf("in this situation, VT=(k1a/k2a) \n");
  }
  ret=simOxygen(x, y1, y3, NULL, NULL, n,
                0.2, 0.4, 0.0, 0.2, 0.2, 0.0, 0.0, 0,
                sy1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, verbose-2);
  if(ret!=0) return(111);
  if(0) {
    printf("X\tY1\tY2\tSY1\n");
    for(i=0; i<n; i++) printf("%g\t%g\t%g\t%g\n", x[i], y1[i], y3[i], sy1[i]);
    printf("\n");
  }
  liIntegrate(x, sy1, n, yi, 0, verbose-5); sauc1=yi[n-1]; f=sauc1/auc1; 
  if(verbose>2) {
    printf("input auc=%g ; output auc=%g ; output/input=%g\n", auc1, sauc1, f);
  }
  if(!doubleMatch(0.5, f, 0.001)) return(112);


  if(verbose>1) {
    printf("\ntesting with tracer2, tracer1=0\n");
    printf("in this situation, VT=(k1b/k2b) \n");
  }
  ret=simOxygen(x, y3, y1, NULL, NULL, n,
                0.2, 0.4, 0.1, 0.2, 0.3, 0.0, 0.0, 0,
                sy1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, verbose-2);
  if(ret!=0) return(121);
  if(0) {
    printf("X\tY1\tY2\tSY1\n");
    for(i=0; i<n; i++) printf("%g\t%g\t%g\t%g\n", x[i], y3[i], y1[i], sy1[i]);
    printf("\n");
  }
  liIntegrate(x, sy1, n, yi, 0, verbose-5); sauc1=yi[n-1]; f=sauc1/auc1; 
  if(verbose>2) {
    printf("input auc=%g ; output auc=%g ; output/input=%g\n", auc1, sauc1, f);
  }
  if(!doubleMatch(0.666667, f, 0.001)) return(122);



  if(verbose>1) printf("\nMaking steadystate data for testing\n");
  double cab, cvb;
  for(i=0; i<n; i++) {x[i]=(double)i; y1[i]=y2[i]=y3[i]=sy1[i]=0.0;}
  for(i=1; i<n; i++) {y1[i]=10.0; y2[i]=5.0;}
  if(0) {
    printf("X\tY1\tY2\tY3\n");
    for(i=0; i<n; i++) printf("%g\t%g\t%g\t%g\n", x[i], y1[i], y2[i], y3[i]);
    printf("\n");
  }

  if(verbose>1) {
    printf("\nafter steady state is reached, tracer1 venous/arterial ratio\n");
    printf("should be 1 - km/(k2a+km) \n");
  }
  ret=simOxygen(x, y1, y2, NULL, NULL, n,
                0.2, 0.4, 0.1, 0.2, 0.3, 0.0, 0.0, 0,
                NULL, NULL, NULL, NULL, NULL, NULL, sy1, NULL, verbose-2);
  if(ret!=0) return(201);
  if(0) {
    printf("X\tY1\tY2\tSY1\n");
    for(i=0; i<n; i++) printf("%g\t%g\t%g\t%g\n", x[i], y1[i], y2[i], sy1[i]);
    printf("\n");
  }
  cab=y1[n-1]; cvb=sy1[n-1]; f=cvb/cab; 
  if(verbose>2) {
    printf("Cab=%g ; Cvb=%g ; Cvb/Cab=%g\n", cab, cvb, f);
  }
  if(!doubleMatch(0.8, f, 0.001)) return(202);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
