/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmSameImage(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmSameImage(NULL, NULL, verbose-1)!=0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  DCMFILE dcm1, dcm2; dcmfileInit(&dcm1); dcmfileInit(&dcm2);

  if(verbose>1) printf("\nTrying with empty input...\n");
  if(dcmSameImage(&dcm1, &dcm2, verbose-1)!=1) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmFileList(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmFileList(NULL, NULL, NULL)!=TPCERROR_FAIL) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmFileRemove(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmFileRemove(NULL, NULL)!=TPCERROR_FAIL) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\nTested elsewhere.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
