/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmmatrixInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMMATRIX m;

  if(verbose>1) printf("\ntry with NULL input...\n");
  dcmmatrixInit(NULL);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry with correct input...\n");
  dcmmatrixInit(&m);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmmatrixFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMMATRIX m;

  if(verbose>1) printf("\ntry with NULL input...\n");
  dcmmatrixFree(NULL);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry with correct but empty input...\n");
  dcmmatrixInit(&m);
  dcmmatrixFree(&m);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmmlInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMML ml;

  if(verbose>1) printf("\ntry with NULL input...\n");
  dcmmlInit(NULL);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry with correct input...\n");
  dcmmlInit(&ml);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmmlFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMML ml;

  if(verbose>1) printf("\ntry with NULL input...\n");
  dcmmlFree(NULL);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry with correct but empty input...\n");
  dcmmlInit(&ml);
  dcmmlFree(&ml);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmmlAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMML ml; dcmmlInit(&ml);

  if(verbose>1) printf("\ntry with NULL input...\n");
  if(dcmmlAllocate(NULL, 0)!=TPCERROR_FAIL) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry to add zero elements...\n");
  if(dcmmlAllocate(&ml, 0)!=TPCERROR_OK) return(2);

  if(verbose>1) printf("\ntry to add one element...\n");
  if(dcmmlAllocate(&ml, 1)!=TPCERROR_OK) {dcmmlFree(&ml); return(11);}
  if(ml.nr!=0 && ml.anr!=1) {dcmmlFree(&ml); return(12);}

  if(verbose>1) printf("\ntry to add two more elements...\n");
  if(dcmmlAllocate(&ml, 2)!=TPCERROR_OK) {dcmmlFree(&ml); return(21);}
  if(ml.nr!=0 && ml.anr!=2) {dcmmlFree(&ml); return(22);}

  ml.nr=2;
  if(dcmmlAllocate(&ml, 2)!=TPCERROR_OK) {dcmmlFree(&ml); return(23);}
  if(ml.nr!=2 && ml.anr!=4) {dcmmlFree(&ml); return(24);}

  dcmmlFree(&ml);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmMListRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\ntry with NULL input...\n");
  if(dcmMListRead(NULL, NULL, NULL)!=TPCERROR_FAIL) return(1);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  int ret;

  if(verbose>1) printf("\nreading file list...\n");
  IFT fl; iftInit(&fl);
  ret=dcmFileList("./f170.dcm", &fl, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&fl); return(11);}

  DCMML ml; dcmmlInit(&ml);

  if(verbose>1) printf("\nreading matrices...\n");
  ret=dcmMListRead(&fl, &ml, NULL);
  iftFree(&fl);
  if(ret!=TPCERROR_OK) {dcmmlFree(&ml); return(12);}
  if(verbose>2) {
    printf("matrix_nr := %u\n", ml.nr);
  }
  if(ml.nr!=1) {dcmmlFree(&ml); return(13);}

  if(verbose>1) printf("\nsort matrices...\n");
  dcmmlSortByPlane(&ml, NULL);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  dcmmlFree(&ml);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmmlSortByPlane(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\n Tested in other function \n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
