/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_strDateValid(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(strDateValid(NULL)<=0) return(1);
  if(strDateValid("2013-10-31")!=0) return(2);
  if(strDateValid("2013-10-32")>=0) return(3);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateValid2(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char buf[64];
  
  if(strDateValid2(NULL, NULL)<=0) return(1);
  if(strDateValid2("2013-10-31", buf)==0) return(2);
  if(strDateValid2("31.10.2013", buf)!=0) return(3);
  if(strcmp(buf, "2013-10-31")!=0) return 3;
  if(strDateValid2("31.13.2013", buf)>=0) return(4);
  if(strDateValid2("31.10.2013 10:00:00", buf)!=0) return 5;
  if(strcmp(buf, "2013-10-31")!=0) return 5;
  if(strDateValid2("31/10/2013", buf)!=0) return(13);
  if(strcmp(buf, "2013-10-31")!=0) return 13;
  if(strDateValid2("31/13/2013", buf)>=0) return(14);
  if(strDateValid2("1/1/1970", buf)!=0) return 15;
  if(strcmp(buf, "1970-01-01")!=0) return 15;
  if(strDateValid2("1/12/1970", buf)!=0) return 16;
  if(strcmp(buf, "1970-12-01")!=0) return 16;
  if(strDateValid2("31/1/1970", buf)!=0) return 17;
  if(strcmp(buf, "1970-01-31")!=0) return 17;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateValid3(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char buf[64];

  if(strDateValid3(NULL, NULL)<=0) return 1;
  if(strDateValid3("2013-10-31", buf)==0) return 2;
  if(strDateValid3("31.10.13", buf)!=0) return 3;
  if(strcmp(buf, "2013-10-31")!=0) return 3;
  if(strDateValid3("31.13.13", buf)>=0) return 4;
  if(strDateValid3("31.10.13 10:00:00", buf)!=0) return 5;
  if(strcmp(buf, "2013-10-31")!=0) return 5;
  if(strDateValid3("31/10/13", buf)!=0) return 13;
  if(strcmp(buf, "2013-10-31")!=0) return 13;
  if(strDateValid3("31/13/13", buf)>=0) return 14;
  if(strcmp(buf, "2013-10-31")!=0) return 14;
  if(strDateValid3("1/1/70", buf)!=0) return 15;
  if(strcmp(buf, "1970-01-01")!=0) return 15;
  if(strDateValid3("1/12/70", buf)!=0) return 16;
  if(strcmp(buf, "1970-12-01")!=0) return 16;
  if(strDateValid3("31/1/70", buf)!=0) return 17;
  if(strcmp(buf, "1970-01-31")!=0) return 17;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateValid4(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char buf[64];
  int o, y, m, d;

  if(strDateValid4(0, NULL, NULL, NULL, NULL)==0) return 1;

  o=20131031;
  if(verbose>1) printf("%d\n", o);
  if(strDateValid4(o, buf, &y, &m, &d)!=0) return 2;
  if(verbose>2) printf("  -> %04d-%02d-%02d\n", y, m, d);
  if(y!=2013 || m!=10 || d!=31) return 2;
  if(strDateValid4(o, buf, NULL, NULL, NULL)!=0) return 2;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31")!=0) return 2;

  o=20000101;
  if(verbose>1) printf("%d\n", o);
  if(strDateValid4(o, buf, &y, &m, &d)!=0) return 3;
  if(verbose>2) printf("  -> %04d-%02d-%02d\n", y, m, d);
  if(y!=2000 || m!=1 || d!=1) return 3;
  if(strDateValid4(o, buf, NULL, NULL, NULL)!=0) return 3;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2000-01-01")!=0) return 3;

  o=19750101;
  if(verbose>1) printf("%d\n", o);
  if(strDateValid4(o, buf, &y, &m, &d)!=0) return 4;
  if(verbose>2) printf("  -> %04d-%02d-%02d\n", y, m, d);
  if(verbose>2) printf("  -> %s\n", buf);
  if(y!=1975 || m!=1 || d!=1) return 4;
  if(strcmp(buf, "1975-01-01")!=0) return 4;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strTimeValid(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(strTimeValid(NULL)<=0) return 1;
  if(strTimeValid("12.57.13")==0) return 2;
  if(strTimeValid("12:57:13")!=0) return 3;
  if(strTimeValid("12:01:61")>=0) return 4;
  if(strTimeValid("00:00:00")!=0) return 5;
  if(strTimeValid("23:59:59")!=0) return 6;
  if(strTimeValid("24:00:00")==0) return 7;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateTimeValid(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char str[64], buf[64];

  if(strDateTimeValid(NULL, NULL)<=0) return 1;
  if(strDateTimeValid("", NULL)<=0) return 1;

  strcpy(str, "  2013-10-31 12:593");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)<=0) return 2;

  strcpy(str, "2013-10-31 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 3;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31 12:59:13")!=0) return 3;

  strcpy(str, "31.10.2013 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 4;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31 12:59:13")!=0) return 4;

  strcpy(str, "31.10.13 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 5;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31 12:59:13")!=0) return 5;

  strcpy(str, "31/10/2013 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 4;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31 12:59:13")!=0) return 4;

  strcpy(str, "31/10/13 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 5;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31 12:59:13")!=0) return 5;

  strcpy(str, "1/1/1970 00:00:00");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 6;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "1970-01-01 00:00:00")!=0) return 6;

  strcpy(str, "2013-10-31 12:59:13 ignored?");
  if(verbose>1) printf("str := '%s'\n", str);
  if(strDateTimeValid(str, buf)!=0) return 10;
  if(verbose>2) printf("  -> %s\n", buf);
  if(strcmp(buf, "2013-10-31 12:59:13")!=0) return 6;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateTimeRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char str1[64], str2[64];
  struct tm dt;
  int ret;
  
  strcpy(str1, "");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret==0) return 1;
  
  strcpy(str1, "  2013-10-31 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret==0) return 2;

  strcpy(str1, "2013-10-31 12:59:13 something else");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret!=0) return 3;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 3;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31 12:59:13")!=0) return 3;

  strcpy(str1, "1897-02-12 01:12:00");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret!=0) return 4;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 4;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "1897-02-12 01:12:00")!=0) return 4;

  strcpy(str1, "31.10.2013\t12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret!=0) return 5;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 5;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31 12:59:13")!=0) return 5;

  strcpy(str1, "31/10/2013 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret!=0) return 6;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 6;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31 12:59:13")!=0) return 6;

  strcpy(str1, "31.10.13 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret!=0) return 7;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 7;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31 12:59:13")!=0) return 7;

  strcpy(str1, "31/10/87 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret!=0) return 8;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 8;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "1987-10-31 12:59:13")!=0) return 8;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }


  char str1[64], str2[64];
  struct tm dt;
  int ret;
  
  strcpy(str1, "");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret==0) return 1;
  
  strcpy(str1, "  2013-10-31");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateTimeRead(str1, &dt); if(ret==0) return 2;

  strcpy(str1, "2013-10-31 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 3;
  ret=strftime(str2, 32, "%Y-%m-%d", &dt); if(ret==0) return 3;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31")!=0) return 3;

  strcpy(str1, "1897-02-12");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 4;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 4;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "1897-02-12 00:00:00")!=0) return 4;

  strcpy(str1, "31.10.2013\t12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 5;
  ret=strftime(str2, 32, "%Y-%m-%d", &dt); if(ret==0) return 5;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31")!=0) return 5;

  strcpy(str1, "31/10/2013");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 6;
  ret=strftime(str2, 32, "%Y-%m-%d", &dt); if(ret==0) return 6;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31")!=0) return 6;

  strcpy(str1, "31.10.13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 7;
  ret=strftime(str2, 32, "%Y-%m-%d", &dt); if(ret==0) return 7;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31")!=0) return 7;

  strcpy(str1, "31.10.13 12:59:13");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 8;
  ret=strftime(str2, 32, "%Y-%m-%d", &dt); if(ret==0) return 8;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "2013-10-31")!=0) return 8;

  strcpy(str1, "31/10/87");
  if(verbose>1) printf("str := '%s'\n", str1);
  ret=strDateRead(str1, &dt); if(ret!=0) return 9;
  ret=strftime(str2, 32, "%Y-%m-%d %H:%M:%S", &dt); if(ret==0) return 9;
  if(verbose>2) printf("  -> '%s'\n", str2);
  if(strcmp(str2, "1987-10-31 00:00:00")!=0) return 9;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_time_to_tm(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(verbose>1) printf("no testing for this function.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tmDifference(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  struct tm d1, d2;
  time_t t1, t2;
  double f;

  d1.tm_year=2014-1900; d1.tm_mday=21; d1.tm_mon=7;
  d1.tm_hour=19; d1.tm_min=32; d1.tm_sec=12; d1.tm_isdst=-1;
  d2.tm_year=2014-1900; d2.tm_mday=21; d2.tm_mon=7;
  d2.tm_hour=19; d2.tm_min=32; d2.tm_sec=12; d2.tm_isdst=-1;
  t1=mktime(&d1); t2=mktime(&d2); f=tmDifference(&d1, &d2);
  if(verbose>1) printf("\n%s%s = %g s\n", ctime(&t1), ctime(&t2), f);
  if(!doubleMatch(f, 0.0, 1.0E-03)) return 1;

  d2.tm_sec=d1.tm_sec+1;
  t1=mktime(&d1); t2=mktime(&d2); f=tmDifference(&d1, &d2);
  if(verbose>1) printf("\n%s%s = %g s\n", ctime(&t1), ctime(&t2), f);
  if(!doubleMatch(f, -1.0, 1.0E-03)) return 2;

  d2.tm_sec=d1.tm_sec-1;
  t1=mktime(&d1); t2=mktime(&d2); f=tmDifference(&d1, &d2);
  if(verbose>1) printf("\n%s%s = %g s\n", ctime(&t1), ctime(&t2), f);
  if(!doubleMatch(f, +1.0, 1.0E-03)) return 3;

  d2.tm_sec=d1.tm_sec;
  d2.tm_mday=d1.tm_mday-1;
  t1=mktime(&d1); t2=mktime(&d2); f=tmDifference(&d1, &d2);
  if(verbose>1) printf("\n%s%s = %g s\n", ctime(&t1), ctime(&t2), f);
  if(!doubleMatch(f, (double)24*60*60, 1.0E-03)) return 3;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tmAdd(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("testing with NULL input\n");
  struct tm *meh=NULL; tmAdd(1.0, meh);
  if(meh!=NULL) return 1;

  struct tm d;
  time_t t1, t2;
  double f;

  d.tm_year=2014-1900; d.tm_mday=21; d.tm_mon=7;
  d.tm_hour=19; d.tm_min=32; d.tm_sec=12; d.tm_isdst=-1;
  t1=timegm(&d);  
  tmAdd(0, &d); 
  t2=timegm(&d); f=difftime(t1, t2);
  if(verbose>1) printf("\n%s + 0 s = %s\n", ctime(&t1), ctime(&t2));
  if(verbose>2) printf(" f := %g\n", f);
  if(!doubleMatch(f, 0.0, 1.0E-03)) return 2;
  
  tmAdd(10, &d); 
  t2=timegm(&d); f=difftime(t1, t2);
  if(verbose>1) printf(" + 10 s = %s\n", ctime(&t2));
  if(verbose>2) printf(" f := %g\n", f);
  if(!doubleMatch(f, -10.0, 1.0E-03)) return 3;
  
  tmAdd(-15, &d); 
  t2=timegm(&d); f=difftime(t1, t2);
  if(verbose>1) printf(" - 15 s = %s\n", ctime(&t2));
  if(verbose>2) printf(" f := %g\n", f);
  if(!doubleMatch(f, 5.0, 1.0E-03)) return 4;
  
  tmAdd(7205, &d); 
  t2=timegm(&d); f=difftime(t1, t2);
  if(verbose>1) printf(" + 7205 s = %s\n", ctime(&t2));
  if(verbose>2) printf(" f := %g\n", f);
  if(!doubleMatch(f, -7200, 1.0E-03)) return 5;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateTimeDifference(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double f;

  if(verbose>1) printf("\nTesting with NULL input...\n");
  f=strDateTimeDifference(NULL, NULL);
  if(!doubleMatch(f, 0, 1.0E-30)) return(1);

  char s1[32], s2[32];
  strcpy(s1, "2017-05-08 21:59:03");
  strcpy(s2, "2017-05-08 21:59:02");
  if(verbose>1) printf("'%s' vs '%s'\n", s1, s2);
  f=strDateTimeDifference(s1, s2);
  if(verbose>2) printf(" -> %g\n", f);
  if(!doubleMatch(f, 1.0, 1.0E-30)) return(11);

  if(verbose>1) printf("'%s' vs '%s'\n", s2, s1);
  f=strDateTimeDifference(s2, s1);
  if(verbose>2) printf(" -> %g\n", f);
  if(!doubleMatch(f, -1.0, 1.0E-30)) return(12);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strDateTimeAdd(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTesting with NULL input...\n");
  if(!strDateTimeAdd(0, NULL)) return(1);
  if(!strDateTimeAdd(0, "")) return(2);
  if(verbose>1) printf("\nTesting with stupid input...\n");
  if(!strDateTimeAdd(10, "YYYY-MM-DD hh:mm:ss")) return(3);

  if(verbose>1) printf("\nTesting with decent input...\n");
  char s1[32], s2[32];
  strcpy(s1, "2017-05-08 21:59:03");
  strcpy(s2, "2017-05-08 21:59:02");
  if(verbose>1) printf("'%s' vs '%s'\n", s1, s2);
  if(strDateTimeAdd(-1, s1)) return(11);
  if(verbose>2) printf(" -> %s\n", s1);
  if(strcmp(s1, s2)) return(12);

  if(strDateTimeAdd(0, s1)) return(13);
  if(verbose>2) printf(" -> %s\n", s1);
  if(strcmp(s1, s2)) return(14);

  strcpy(s1, "2017-12-31 23:59:03");
  strcpy(s2, "2018-01-01 00:00:02");
  if(strDateTimeAdd(59, s1)) return(21);
  if(verbose>2) printf(" -> %s\n", s1);
  if(strcmp(s1, s2)) return(22);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
