/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_strIsValidNumber(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr;
  char str[64];

  cptr=NULL; if(verbose>1) printf("str := NULL\n");
  if(strIsValidNumber(cptr)==1) return(1);

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(2);
  strcpy(str, "."); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(3);
  strcpy(str, " "); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(4);
  strcpy(str, "a"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(5);
  strcpy(str, "a1"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(6);
  strcpy(str, "1a"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(7);
  strcpy(str, "1 "); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(8);
  strcpy(str, " 1"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(9);

  strcpy(str, "0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(11);
  strcpy(str, "0000"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(12);
  strcpy(str, "+0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(13);
  strcpy(str, "-0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(14);
  strcpy(str, "0E0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(15);
  strcpy(str, "0E+0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(16);
  strcpy(str, "0E-0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(17);
  strcpy(str, "-0e-0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(18);

  strcpy(str, "1.1"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(21);
  strcpy(str, "1,1"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(22);
  strcpy(str, ".1"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(23);
  strcpy(str, ",1"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(24);
  strcpy(str, "1."); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(25);
  strcpy(str, "1,"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(26);

  strcpy(str, "1.E+100"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(31);
  strcpy(str, "1,E+100"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(32);
  strcpy(str, "-1.E-100"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(33);
  strcpy(str, "-1,E-100"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)!=1) return(34);

  strcpy(str, "1.E+10.0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(41);
  strcpy(str, "1,E+10,0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(42);
  strcpy(str, "1.E10.0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(43);
  strcpy(str, "1,E10,0"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(44);
  strcpy(str, "1.E"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(45);
  strcpy(str, "1,E"); if(verbose>1) printf("str := '%s'\n", str);
  if(strIsValidNumber(str)==1) return(46);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_atofVerified(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[64];
  double v;

  if(verbose>1) printf("str := NULL\n");
  v=atofVerified(NULL); if(verbose>2) printf("  -> %g\n", v);
  if(!isnan(v)) return(1);

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(!isnan(v)) return(2);

  strcpy(str, " 123 "); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(!isnan(v)) return(3);
  strcpy(str, " 1-23 "); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(!isnan(v)) return(4);

  strcpy(str, "1.23"); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(fabs(v-1.23)>1.0E-010) return(11);
  strcpy(str, "1,23"); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(fabs(v-1.23)>1.0E-010) return(12);
  strcpy(str, "1.23E+002"); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(fabs(v-123)>1.0E-010) return(13);
  strcpy(str, "1,23e+002"); if(verbose>1) printf("str := '%s'\n", str);
  v=atofVerified(str); if(verbose>2) printf("  -> %g\n", v);
  if(fabs(v-123)>1.0E-010) return(14);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_atofCheck(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[64];
  double v;
  int ret;

  if(verbose>1) printf("str := NULL\n");
  ret=atofCheck(NULL, NULL);
  if(ret==0) return(1);

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, &v); if(verbose>2) printf("  -> %g\n", v);
  if(ret==0 || !isnan(v)) return(2);

  strcpy(str, "NaN"); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, NULL);
  if(ret==0) return(3);

  strcpy(str, " 0"); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, &v); if(verbose>2) printf("  -> %g\n", v);
  if(ret==0 || !isnan(v)) return(4);

  strcpy(str, "1.2345"); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, &v); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-1.2345)>1.0E-010) return(11);
  strcpy(str, "1,2345"); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, &v); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-1.2345)>1.0E-010) return(12);
  strcpy(str, "+1.2345E4"); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, &v); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-12345)>1.0E-010) return(13);
  strcpy(str, "-1,2345E4"); if(verbose>1) printf("str := '%s'\n", str);
  ret=atofCheck(str, &v); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-(-12345))>1.0E-010) return(14);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strHaveDecimalComma(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr;

  cptr=NULL;
  if(strHaveDecimalComma(cptr)!=0) return(1);

  if(strHaveDecimalComma("62.1")!=0) return(2);
  if(strHaveDecimalComma("62,1")!=1) return(3);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strHaveDecimalSeparator(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr;

  cptr=NULL;
  if(strHaveDecimalSeparator(cptr)!=0) return(1);

  if(strHaveDecimalSeparator("621")!=0) return(2);
  if(strHaveDecimalSeparator("62.1")!=1) return(3);
  if(strHaveDecimalSeparator("62,1")!=2) return(4);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_atofList(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("\n testing with NULL input \n\n");
  {  
    char *cptr=NULL;
    double xl[10];
    if(atofList(cptr, cptr, xl, 5)>0) return(1);
  }
  
  if(verbose>1) printf("\n testing with reasonable data \n\n");
  {  
    char *s1="1.0;2.0;3.0";
    char *s2=";,\t";
    double xl[10];
    int n;
    if(verbose>2) printf("\n s1 := '%s'\n", s1);
    n=atofList(s1, s2, xl, 10);
    if(verbose>2) printf(" -> n := %d\n", n);
    if(verbose>2 && n>0) {
      printf(" -> %g", xl[0]);
      for(int i=1; i<n; i++) printf(", %g", xl[i]);
      printf("\n");
    }
    if(n!=3) return 11;
    if(!doubleMatch(xl[0], 1.0, 1.0E-10)) return 12;
    if(!doubleMatch(xl[1], 2.0, 1.0E-10)) return 13;
    if(!doubleMatch(xl[2], 3.0, 1.0E-10)) return 14;
  }
  

  if(verbose>1) printf("\n testing with not-so-good string \n\n");
  {  
    char *s1=" 1.0; 2.0; 3.0; ";
    char *s2=";,\t ";
    double xl[10];
    int n;
    if(verbose>2) printf("\n s1 := '%s'\n", s1);
    n=atofList(s1, s2, xl, 10);
    if(verbose>2) printf(" -> n := %d\n", n);
    if(verbose>2 && n>0) {
      printf(" -> %g", xl[0]);
      for(int i=1; i<n; i++) printf(", %g", xl[i]);
      printf("\n");
    }
    if(n!=3) return 21;
    if(!doubleMatch(xl[0], 1.0, 1.0E-10)) return 22;
    if(!doubleMatch(xl[1], 2.0, 1.0E-10)) return 23;
    if(!doubleMatch(xl[2], 3.0, 1.0E-10)) return 24;
  }
  
  if(verbose>1) printf("\n string contains just one value \n\n");
  {  
    char *s1=" -1.0 ";
    char *s2=";,\t ";
    double xl[10];
    int n;
    if(verbose>2) printf("\n s1 := '%s'\n", s1);
    n=atofList(s1, s2, xl, 10);
    if(verbose>2) printf(" -> n := %d\n", n);
    if(verbose>2 && n>0) {
      printf(" -> %g", xl[0]);
      for(int i=1; i<n; i++) printf(", %g", xl[i]);
      printf("\n");
    }
    if(n!=1) return 31;
    if(!doubleMatch(xl[0], -1.0, 1.0E-10)) return 32;
  }
  
  if(verbose>1) printf("\n string contains no values at all \n\n");
  {  
    char *s1=";; ";
    char *s2=";,\t ";
    double xl[10];
    int n;
    if(verbose>2) printf("\n s1 := '%s'\n", s1);
    n=atofList(s1, s2, xl, 10);
    if(verbose>2) printf(" -> n := %d\n", n);
    if(n!=0) return 41;
  }
  
  if(verbose>1) printf("\n string contains more values than allowed \n\n");
  {  
    char *s1="1;2;3;4;5;6;7;8;9;10;11";
    char *s2=";,\t ";
    double xl[3];
    int n;
    n=atofList(s1, s2, xl, 3);
    if(verbose>2) printf(" -> n := %d\n", n);
    if(n!=3) return 51;
    if(!doubleMatch(xl[0], 1.0, 1.0E-10)) return 52;
    if(!doubleMatch(xl[1], 2.0, 1.0E-10)) return 53;
    if(!doubleMatch(xl[2], 3.0, 1.0E-10)) return 54;
  }

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
