/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
/* Local functions */
void test_statusLocal(
  FILE *fp,
  TPCSTATUS *status
) {
  if(status->verbose>2) fprintf(fp, "we are now in function %s()\n", __func__);
  if(status->verbose>2) fprintf(fp, "status as we got it:\n");
  statusPrint(fp, status);
  if(status->verbose>2) fprintf(fp, "setting status\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(status->verbose>2) fprintf(fp, "status as it is now:\n");
  statusPrint(fp, status);
  if(status->verbose>2) fprintf(fp, "returning from %s()\n", __func__);
}
/*****************************************************************************/

/*****************************************************************************/
int test_statusPrint(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  TPCSTATUS localstatus;
  if(verbose>1) printf("initiating status struct\n");
  statusInit(&localstatus); localstatus.verbose=verbose;
  if(verbose>1) printf("printing empty status struct\n");
  statusPrint(stdout, &localstatus);
  if(verbose>1) printf("setting status\n");
  statusSet(&localstatus, __func__, __FILE__, __LINE__, 0);
  if(verbose>1) printf("printing status struct\n");
  statusPrint(stdout, &localstatus);
  if(verbose>1) printf("calling another function which sets status\n");
  test_statusLocal(stdout, &localstatus);
  if(verbose>1) printf("printing status struct\n");
  statusPrint(stdout, &localstatus);
  statusFree(&localstatus);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_errorMsg(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  fprintf(stderr, "Simulated OK: %s\n", errorMsg(TPCERROR_OK));
  fprintf(stderr, "Simulated Error: %s\n", errorMsg(TPCERROR_NO_FILE));
  fprintf(stderr, "invalid error: %s\n", errorMsg(99999));

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
