/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_strTokenNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256], str2[256];
  int n;

  n=strTokenNr(NULL, NULL); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(1);

  strcpy(str1, "");
  strcpy(str2, "");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strTokenNr(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(2);

  strcpy(str1, "Bim Bam Bum");
  strcpy(str2, "");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strTokenNr(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(3);

  strcpy(str1, "Bim Bam Bum");
  strcpy(str2, " ");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strTokenNr(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=3) return(4);

  strcpy(str1, "Bim Bam Bum");
  strcpy(str2, " \t,;");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strTokenNr(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=3) return(5);

  strcpy(str1, " Bim\tBam, Bum; ");
  strcpy(str2, " \t,;");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strTokenNr(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=3) return(6);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strTokenNCpy(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256], str2[256], str3[256];
  int n, i;

  n=strTokenNCpy(NULL, NULL, 0, NULL, 256);
  if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(1);

  n=strTokenNCpy(NULL, NULL, 1, NULL, 256);
  if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(1);

  strcpy(str1, "");
  strcpy(str2, "");
  i=1;
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\ni := %d\n", str1, str2, i);
  n=strTokenNCpy(str1, str2, i, str3, 256);
  if(verbose>2) printf("  -> n := %d\n  -> str3 := '%s'\n", n, str3);
  if(n!=0) return(2);

  strcpy(str1, "Bim, Bam, and Bum");
  strcpy(str2, " ,");
  i=1;
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\ni := %d\n", str1, str2, i);
  n=strTokenNCpy(str1, str2, i, str3, 256);
  if(verbose>2) printf("  -> n := %d\n  -> str3 := '%s'\n", n, str3);
  if(n!=3 || strcmp(str3, "Bim")!=0) return(3);

  strcpy(str1, "Bim, Bam, and Bum");
  strcpy(str2, " ,");
  i=2;
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\ni := %d\n", str1, str2, i);
  n=strTokenNCpy(str1, str2, i, str3, 256);
  if(verbose>2) printf("  -> n := %d\n  -> str3 := '%s'\n", n, str3);
  if(n!=3 || strcmp(str3, "Bam")!=0) return(3);

  strcpy(str1, "Bim, Bam, and Bum");
  strcpy(str2, " ,");
  i=4;
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\ni := %d\n", str1, str2, i);
  n=strTokenNCpy(str1, str2, i, str3, 256);
  if(verbose>2) printf("  -> n := %d\n  -> str3 := '%s'\n", n, str3);
  if(n!=3 || strcmp(str3, "Bum")!=0) return(3);

  strcpy(str1, "Bim, Bam, and Bum");
  strcpy(str2, " ,");
  i=4;
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\ni := %d\n", str1, str2, i);
  n=strTokenNCpy(str1, str2, i, str3, 3);
  if(verbose>2) printf("  -> n := %d\n  -> str3 := '%s'\n", n, str3);
  if(n!=2 || strcmp(str3, "Bu")!=0) return(4);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strChrCount(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char str1[256], str2[256];
  int n;

  n=strChrCount(NULL, NULL); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(1);

  strcpy(str1, "");
  strcpy(str2, "");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(2);

  strcpy(str1, "");
  strcpy(str2, ",");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(3);

  strcpy(str1, "Bim, Bam, Bum");
  strcpy(str2, "");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(4);

  strcpy(str1, "Bim, Bam, Bum");
  strcpy(str2, ",");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=2) return(5);

  strcpy(str1, "Bim, Bam, Bum");
  strcpy(str2, " ,");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=4) return(6);

  strcpy(str1, "  v := 1.0E-003");
  strcpy(str2, ",");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(7);

  strcpy(str1, "  v := 1,0E-003");
  strcpy(str2, ",");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  n=strChrCount(str1, str2); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=1) return(8);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strUppercaseCount(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char str1[256];
  int n;

  n=strUppercaseCount(NULL); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(1);

  strcpy(str1, "");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(2);

  strcpy(str1, "   ");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(3);

  strcpy(str1, "Bim, Bam, Bum");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=3) return(4);

  strcpy(str1, "Bim, bam, bum");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=1) return(5);

  strcpy(str1, "abCdefghijKlmnopQRstuvwxyZ");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=5) return(6);

  strcpy(str1, "  v := 1.0E-003");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=1) return(7);

  strcpy(str1, "  v := 1,0e-003");
  if(verbose>1) printf("str1 := '%s'\n", str1);
  n=strUppercaseCount(str1); if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=0) return(8);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strReplaceChar(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[256], c1, c2;

  c1=(char)0; c2=(char)0;
  strReplaceChar(NULL, c1, c2);
  if(verbose>1) printf("str := '%s'\nc1 := '%c'\nc2 := '%c'\n", str, c1, c2);

  strcpy(str, ""); c1=','; c2='.';
  if(verbose>1) printf("str := '%s'\nc1 := '%c'\nc2 := '%c'\n", str, c1, c2);
  strReplaceChar(str, c1, c2);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(strcmp(str, "")!=0) return(2);

  strcpy(str, ","); c1=','; c2='.';
  if(verbose>1) printf("str := '%s'\nc1 := '%c'\nc2 := '%c'\n", str, c1, c2);
  strReplaceChar(str, c1, c2);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(strcmp(str, ".")!=0) return(3);

  strcpy(str, ";;;;"); c1=';'; c2=',';
  if(verbose>1) printf("str := '%s'\nc1 := '%c'\nc2 := '%c'\n", str, c1, c2);
  strReplaceChar(str, c1, c2);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(strcmp(str, ",,,,")!=0) return(4);

  strcpy(str, "1,01E-E001;2,02E+000;3,03E+001"); c1=','; c2='.';
  if(verbose>1) printf("str := '%s'\nc1 := '%c'\nc2 := '%c'\n", str, c1, c2);
  strReplaceChar(str, c1, c2);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(strcmp(str, "1.01E-E001;2.02E+000;3.03E+001")!=0) return(5);

  strcpy(str, "1.01E-E001\t2.02E+000\t3.03E+001"); c1='\t'; c2=',';
  if(verbose>1) printf("str := '%s'\nc1 := '%c'\nc2 := '%c'\n", str, c1, c2);
  strReplaceChar(str, c1, c2);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(strcmp(str, "1.01E-E001,2.02E+000,3.03E+001")!=0) return(6);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
#ifndef HAVE_STRNDUP // Test only if own implementation is used
int test_strndup(
    TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[256], *cptr;
  int n;

#if(0) // no need to test this because NULL would not be supported anyway
  if(verbose>1) printf("str := 'NULL'\nn := 0\n");
  cptr=strndup(NULL, 0); if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(cptr!=NULL) return 1;
  
  if(verbose>1) printf("str := 'NULL'\nn := 10\n");
  cptr=strndup(NULL, 10); if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(cptr!=NULL) return 2;
#endif

  strcpy(str, ""); n=0;
  if(verbose>1) printf("str := '%s'\nn := %d\n", str, n);
  cptr=strndup(str, n); if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(cptr==NULL || strcmp(cptr, "")!=0) {free(cptr); return 3;}
  free(cptr);

  strcpy(str, "abcdefghijk"); n=0;
  if(verbose>1) printf("str := '%s'\nn := %d\n", str, n);
  cptr=strndup(str, n); if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(cptr==NULL || strcmp(cptr, "")!=0) {free(cptr); return 4;}
  free(cptr);

  strcpy(str, "abcdefghijk"); n=4;
  if(verbose>1) printf("str := '%s'\nn := %d\n", str, n);
  cptr=strndup(str, n);
  if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(strcmp(cptr, "abcd")!=0) {free(cptr); return 5;}
  free(cptr);

  strcpy(str, "abcd"); n=20;
  if(verbose>1) printf("str := '%s'\nn := %d\n", str, n);
  cptr=strndup(str, n);
  if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(strcmp(cptr, "abcd")!=0) {free(cptr); return 6;}
  free(cptr);

  strcpy(str, "abcdefghijk"); n=1;
  if(verbose>1) printf("str := '%s'\nn := %d\n", str, n);
  cptr=strndup(str, n);
  if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(strcmp(cptr, "a")!=0) {free(cptr); return 7;}
  free(cptr);

  strcpy(str, "a"); n=1;
  if(verbose>1) printf("str := '%s'\nn := %d\n", str, n);
  cptr=strndup(str, n);
  if(verbose>2) printf("  -> str := '%s'\n", cptr);
  if(strcmp(cptr, "a")!=0) {free(cptr); return 8;}
  free(cptr);

  return(0);
}
#endif // HAVE_STRNDUP
/*****************************************************************************/

/*****************************************************************************/
int test_strstrNoQuotation(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256], str2[256], *cptr;

  cptr=strstrNoQuotation(NULL, NULL);
  if(cptr!=NULL) return(1);

  strcpy(str1, "");
  strcpy(str2, "");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(strcmp(cptr, "")!=0) return(2);

  strcpy(str1, "bim bam bum");
  strcpy(str2, "");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(strcmp(cptr, str1)!=0) return(3);

  strcpy(str1, "bim bam bum");
  strcpy(str2, "bam");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(strcmp(cptr, "bam bum")!=0) return(4);

  strcpy(str1, "bim 'bam' bum");
  strcpy(str2, "bam");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(cptr!=NULL) return(5);

  strcpy(str1, "bim \" bam \" bum");
  strcpy(str2, "bam");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(cptr!=NULL) return(6);

  strcpy(str1, "bim \"bam' bum");
  strcpy(str2, "bam");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(strcmp(cptr, "bam' bum")!=0) return(7);

  strcpy(str1, "bim \"bam' bum\" - bim bam bum");
  strcpy(str2, "bam");
  if(verbose>1) printf("str1 := '%s'\nstr2 := '%s'\n", str1, str2);
  cptr=strstrNoQuotation(str1, str2);
  if(verbose>2) printf("  -> cptr := '%s'\n", cptr);
  if(strcmp(cptr, "bam bum")!=0) return(8);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strncpyCleanSpaces(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256], str2[256];
  size_t m;
  
  m=strncpyCleanSpaces(NULL, NULL, 0);
  if(m!=0) return(1);

  m=strncpyCleanSpaces(NULL, NULL, 100);
  if(m!=0) return(2);

  strcpy(str1, "this should not be here");
  strcpy(str2, "");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 0);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=0 || strcmp(str1, "")!=0) return(3);

  strcpy(str1, "this should not be here");
  strcpy(str2, "bim bam bum");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 2);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=1 || strcmp(str1, "b")!=0) return(4);

  strcpy(str1, "this should not be here");
  strcpy(str2, "bim bam bum");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=strlen(str2) || strcmp(str1, str2)!=0) return(5);

  strcpy(str1, "this should not be here");
  strcpy(str2, "\"bim bam bum\"");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=strlen(str2) || strcmp(str1, str2)!=0) return(6);

  strcpy(str1, "this should not be here");
  strcpy(str2, "'bim bam bum'");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=strlen(str2) || strcmp(str1, str2)!=0) return(7);

  strcpy(str1, "this should not be here");
  strcpy(str2, "'bim bam bum\"");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=strlen(str2) || strcmp(str1, str2)!=0) return(8);

  strcpy(str1, "this should not be here");
  strcpy(str2, " bim bam bum ");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 4);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=3 || strcmp(str1, "bim")!=0) return(9);

  strcpy(str1, "this should not be here");
  strcpy(str2, "  '\tbim bam bum\n\n");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=13 || strcmp(str1, "'\tbim bam bum")!=0) return(10);

  strcpy(str1, "this should not be here");
  strcpy(str2, " bim 'bam' bum ");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyCleanSpaces(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=13 || strcmp(str1, "bim 'bam' bum")!=0) return(11);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strCleanSpaces(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[256];
  int ret;
  
  ret=strCleanSpaces(NULL);
  if(ret!=0) return(1);

  strcpy(str, "");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "")!=0) return(2);

  strcpy(str, "this and that");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(3);

  strcpy(str, "\"this and that\"");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "\"this and that\"")!=0) return(4);

  strcpy(str, "'this and that'");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "'this and that'")!=0) return(5);

  strcpy(str, "'this and that\"");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "'this and that\"")!=0) return(6);

  strcpy(str, "' this and that '");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "' this and that '")!=0) return(7);

  strcpy(str, "\t' this and that '\n\n");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "' this and that '")!=0) return(8);

  strcpy(str, " this 'and' that ");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this 'and' that")!=0) return(9);

  strcpy(str, "      ' this 'and' that ' ");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "' this 'and' that '")!=0) return(10);

  strcpy(str, "\tthis but not 'that' ");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strCleanSpaces(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this but not 'that'")!=0) return(11);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strncpyClean(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256], str2[256];
  size_t m;
  
  m=strncpyClean(NULL, NULL, 0);
  if(m!=0) return(1);

  m=strncpyClean(NULL, NULL, 100);
  if(m!=0) return(2);

  strcpy(str1, "this should not be here");
  strcpy(str2, "");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 0);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=0 || strcmp(str1, "")!=0) return(3);

  strcpy(str1, "this should not be here");
  strcpy(str2, "bim bam bum");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 2);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=1 || strcmp(str1, "b")!=0) return(4);

  strcpy(str1, "this should not be here");
  strcpy(str2, "bim bam bum");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=strlen(str2) || strcmp(str1, str2)!=0) return(5);

  strcpy(str1, "this should not be here");
  strcpy(str2, "\"bim bam bum\"");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(strcmp(str1, "bim bam bum")!=0) return(6);

  strcpy(str1, "this should not be here");
  strcpy(str2, "'bim bam bum'");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(strcmp(str1, "bim bam bum")!=0) return(7);

  strcpy(str1, "this should not be here");
  strcpy(str2, "'bim bam bum\"");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(strcmp(str1, "bim bam bum")!=0) return(8);

  strcpy(str1, "this should not be here");
  strcpy(str2, "'bim bam bum'");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 4);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=3 || strcmp(str1, "bim")!=0) return(9);

  strcpy(str1, "this should not be here");
  strcpy(str2, "  '\tbim bam bum\n\n\"");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=11 || strcmp(str1, "bim bam bum")!=0) return(10);

  strcpy(str1, "this should not be here");
  strcpy(str2, " bim 'bam' bum ");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=13 || strcmp(str1, "bim 'bam' bum")!=0) return(11);

  strcpy(str1, "this should not be here");
  strcpy(str2, "' bim 'bam' bum '");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=13 || strcmp(str1, "bim 'bam' bum")!=0) return(12);

  strcpy(str1, "this should not be here");
  strcpy(str2, "       Accepted format-id's for the output count-rate file");
  if(verbose>1) printf("str2 := '%s'\n", str2);
  m=strncpyClean(str1, str2, 100);
  if(verbose>2) printf("  -> str1 := '%s'\n", str1);
  if(m!=51 || 
     strcmp(str1, "Accepted format-id's for the output count-rate file")!=0) 
    return(13);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strClean(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[256];
  int ret;
  
  ret=strClean(NULL);
  if(ret!=0) return(1);

  strcpy(str, "");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "")!=0) return(2);

  strcpy(str, "this and that");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(3);

  strcpy(str, "\"this and that\"");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(4);

  strcpy(str, "'this and that'");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(5);

  strcpy(str, "'this and that\"");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(6);

  strcpy(str, "' this and that '");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(7);

  strcpy(str, "\t' this and that '\n\n");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this and that")!=0) return(8);

  strcpy(str, " this 'and' that ");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this 'and' that")!=0) return(9);

  strcpy(str, "' this 'and' that '");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this 'and' that")!=0) return(10);

  strcpy(str, "this but not 'that'");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this but not 'that'")!=0) return(11);

  strcpy(str, "' this: that");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=strClean(str);
  if(verbose>2) printf("  -> str := '%s'\n", str);
  if(ret!=0 || strcmp(str, "this: that")!=0) return(12);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strTokenDup(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256], str2[256], *str3, *cptr;
  int next, n;
  
  str3=strTokenDup(NULL, NULL, NULL);
  if(str3!=NULL) return(1);

  strcpy(str1, " line1 \n line2 \n line3 \n");
  strcpy(str2, "");
  if(verbose>1) printf("str1 :=\n'%s'\nstr2 := '%s'\n", str1, str2);
  str3=strTokenDup(str1, str2, NULL);
  if(verbose>2) printf("  -> token := '%s'\n", str3);
  if(strcmp(str3, str1)!=0) {free(str3); return(2);}
  free(str3);

  strcpy(str1, " line1 \n line2 \n line3 \n");
  strcpy(str2, "\n");
  if(verbose>1) printf("str1 :=\n'%s'\nstr2 := '%s'\n", str1, "\\n");
  str3=strTokenDup(str1, str2, &next);
  if(verbose>2) printf("  -> token := '%s'\n", str3);
  if(strcmp(str3, " line1 ")!=0) {free(str3); return(3);}
  if(verbose>2) printf("  -> next := %d\n", next);
  free(str3);
  cptr=str1+next;
  if(verbose>1) printf("str1 :=\n'%s'\nstr2 := '%s'\n", cptr, "\\n");
  str3=strTokenDup(cptr, str2, &next);
  if(verbose>2) printf("  -> token := '%s'\n", str3);
  if(strcmp(str3, " line2 ")!=0) {free(str3); return(3);}
  if(verbose>2) printf("  -> next := %d\n", next);
  free(str3);
  cptr=cptr+next;
  if(verbose>1) printf("str1 :=\n'%s'\nstr2 := '%s'\n", cptr, "\\n");
  str3=strTokenDup(cptr, str2, &next);
  if(verbose>2) printf("  -> token := '%s'\n", str3);
  if(strcmp(str3, " line3 ")!=0) {free(str3); return(3);}
  if(verbose>2) printf("  -> next := %d\n", next);
  free(str3);

  strcpy(str1, " line1 \n line2 \n line3 \n");
  strcpy(str2, " \n");
  if(verbose>1) printf("str1 :=\n'%s'\nstr2 := '%s'\n", str1, " \\n");
  n=0; cptr=str1;
  while((str3=strTokenDup(cptr, str2, &next))!=NULL) {
    if(verbose>2) printf("  -> token%d := '%s'\n", n+1, str3);
    free(str3); cptr+=next; n++;
  }
  if(verbose>2) printf("  n := %d\n", n);
  if(n!=3) return 4;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strInPars(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[256];
  int ret;
  
  ret=strInPars(NULL);
  if(ret!=0) return(1);
  
  strcpy(str, "");
  ret=strInPars(str);
  if(ret!=0) return(2);

  strcpy(str, "(");
  ret=strInPars(str);
  if(ret!=0) return(3);

  strcpy(str, "()");
  ret=strInPars(str);
  if(ret==0) return(11);

  strcpy(str, "(}");
  ret=strInPars(str);
  if(ret!=0) return(12);

  strcpy(str, "[]");
  ret=strInPars(str);
  if(ret==0) return(13);

  strcpy(str, "{}");
  ret=strInPars(str);
  if(ret==0) return(14);

  strcpy(str, "--");
  ret=strInPars(str);
  if(ret!=0) return(15);

  strcpy(str, "( )");
  ret=strInPars(str);
  if(ret==0) return(21);

  if(verbose>2) printf("  ok\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strCleanPars(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[256];
  
  /* just checking that does not crash */
  strCleanPars(NULL);
  
  strcpy(str, ""); strCleanPars(str); if(strcmp(str, "")!=0) return(2);
  strcpy(str, "("); strCleanPars(str); if(strcmp(str, "(")!=0) return(3);
  
  strcpy(str, "()"); strCleanPars(str); if(strcmp(str, "")!=0) return(11);
  strcpy(str, "[]"); strCleanPars(str); if(strcmp(str, "")!=0) return(12);
  strcpy(str, "{}"); strCleanPars(str); if(strcmp(str, "")!=0) return(13);

  strcpy(str, "(}"); strCleanPars(str); if(strcmp(str, "(}")!=0) return(21);
  strcpy(str, "[)"); strCleanPars(str); if(strcmp(str, "[)")!=0) return(22);
  strcpy(str, "{)"); strCleanPars(str); if(strcmp(str, "{)")!=0) return(23);

  strcpy(str, " "); strCleanPars(str); if(strcmp(str, " ")!=0) return(31);
  strcpy(str, " [] "); strCleanPars(str); if(strcmp(str, " [] ")!=0) return(32);
  strcpy(str, "ssss"); strCleanPars(str); if(strcmp(str, "ssss")!=0) return(33);

  strcpy(str, "(s)"); strCleanPars(str); if(strcmp(str, "s")!=0) return(41);
  strcpy(str, "[ss]"); strCleanPars(str); if(strcmp(str, "ss")!=0) return(42);
  strcpy(str, "{sss}"); strCleanPars(str); if(strcmp(str, "sss")!=0) return(43);

  if(verbose>2) printf("  ok\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strncatInt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  unsigned int len1=256;
  char str1[len1];
  int n;
  
  /* Originally empty string */
  n=6;
  strcpy(str1, "");
  if(verbose>1) printf("\n '%s' + %d \n", str1, n);
  strncatInt(str1, n, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "6")!=0) return(1);
  
  /* Originally filled string */
  n=555;
  strcpy(str1, "meh");
  if(verbose>1) printf("\n '%s' + %d \n", str1, n);
  strncatInt(str1, n, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "meh555")!=0) return(2);

  /* Not enough space */
  unsigned int len2=10;
  char str2[len2];

  n=123456;
  strcpy(str2, "abcdefg");
  if(verbose>1) printf("\n '%s' + %d \n", str2, n);
  strncatInt(str2, n, len2-strlen(str2)-1);
  if(verbose>1) printf(" -> '%s' \n", str2);
  if(strcmp(str2, "abcdefg12")!=0) return(11);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strncatDouble(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  
  unsigned int len1=256;
  char str1[len1];
  double v;
  
  /* Originally empty string */
  v=6.0;
  strcpy(str1, "");
  if(verbose>1) printf("\n '%s' + %g \n", str1, v);
  strncatDouble(str1, v, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "6")!=0) return(1);
  
  /* Originally filled string */
  v=55.5;
  strcpy(str1, "meh");
  if(verbose>1) printf("\n '%s' + %g \n", str1, v);
  strncatDouble(str1, v, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "meh55.5")!=0) return(2);

  /* Not enough space */
  unsigned int len2=10;
  char str2[len2];

  v=1.23456;
  strcpy(str2, "abcdef");
  if(verbose>1) printf("\n '%s' + %g \n", str2, v);
  strncatDouble(str2, v, len2-strlen(str2)-1);
  if(verbose>1) printf(" -> '%s' \n", str2);
  if(strcmp(str2, "abcdef1.2")!=0) return(11);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strncatIntZ(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  unsigned int len1=256;
  char str1[len1];
  int n, m;
  
  /* Originally empty string */
  n=6; m=100;
  strcpy(str1, "");
  if(verbose>1) printf("\n '%s' + %d (max=%d)\n", str1, n, m);
  strncatIntZ(str1, n, m, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "006")!=0) return(1);
  
  /* Originally filled string */
  n=555; m=1000;
  strcpy(str1, "meh");
  if(verbose>1) printf("\n '%s' + %d (max=%d)\n", str1, n, m);
  strncatIntZ(str1, n, m, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "meh0555")!=0) return(2);

  /* No need for zero-padding */
  n=555; m=200;
  strcpy(str1, "meh");
  if(verbose>1) printf("\n '%s' + %d (max=%d)\n", str1, n, m);
  strncatIntZ(str1, n, m, len1-strlen(str1)-1);
  if(verbose>1) printf(" -> '%s' \n", str1);
  if(strcmp(str1, "meh555")!=0) return(3);

  /* Not enough space */
  unsigned int len2=10;
  char str2[len2];

  n=1234; m=12345;
  strcpy(str2, "abcdef");
  if(verbose>1) printf("\n '%s' + %d (max=%d)\n", str1, n, m);
  strncatIntZ(str2, n, m, len2-strlen(str2)-1);
  if(verbose>1) printf(" -> '%s' \n", str2);
  if(strcmp(str2, "abcdef012")!=0) return(11);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
#ifndef HAVE_STRNLEN // Test only if own implementation is used
int test_strnlen(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  size_t len1=256;
  char str1[len1];
  size_t n, m;

  strcpy(str1, ""); m=len1;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=0) return(1);
  m=0;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=0) return(2);
  m=1;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=0) return(3);

  strcpy(str1, "a"); m=len1;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=1) return(11);
  m=0;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=0) return(12);
  m=1;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=1) return(13);
  m=2;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=1) return(14);

  strcpy(str1, "abcdefghijklmopqrstu"); m=len1;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=20) return(21);
  m=0;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=0) return(22);
  m=20;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=20) return(23);
  m=10;
  n=strnlen(str1, m);
  if(verbose>1) printf("strnlen('%s', %zu) := %zu\n", str1, m, n);
  if(n!=10) return(24);

  if(verbose>1) 
    printf("testing with character array that is not NUL terminated\n");
  size_t len2=8;
  char str2[len2];

  strncpy(str2, "abcdefgh", len2); 
  m=len2;
  n=strnlen(str2, m);
  if(n!=8) return(31);
  m=4;
  n=strnlen(str2, m);
  if(n!=4) return(32);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
#endif //HAVE_STRNLEN
/*****************************************************************************/

/*****************************************************************************/
#ifndef HAVE_STRLCAT // Test only if own implementation is used
int test_strlcat(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  size_t len1=256;
  char str1[len1], str2[len1];
  size_t n, m;

  strcpy(str1, ""); strcpy(str2, ""); m=0;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=0 || strcmp(str1, "")!=0) return(1);

  strcpy(str1, ""); strcpy(str2, ""); m=2;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=0 || strcmp(str1, "")!=0) return(2);

  strcpy(str1, "a"); strcpy(str2, ""); m=2;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=1 || strcmp(str1, "a")!=0) return(11);

  strcpy(str1, ""); strcpy(str2, "b"); m=2;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=1 || strcmp(str1, "b")!=0) return(12);


  strcpy(str1, "abcdefgh"); strcpy(str2, "ijklmnop"); m=10;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=16 || strcmp(str1, "abcdefghi")!=0) return(21);

  strcpy(str1, "abcdefgh"); strcpy(str2, "ijklmnop"); m=8;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=16 || strcmp(str1, "abcdefgh")!=0) return(22);

  strcpy(str1, "abcdefgh"); strcpy(str2, "ijklmnop"); m=16;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=16 || strcmp(str1, "abcdefghijklmno")!=0) return(23);

  strcpy(str1, "abcdefgh"); strcpy(str2, "ijklmnop"); m=17;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=16 || strcmp(str1, "abcdefghijklmnop")!=0) return(24);

  strcpy(str1, "abcdefgh"); strcpy(str2, "ijklmnop"); m=18;
  if(verbose>1) printf("strlcat('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcat(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=16 || strcmp(str1, "abcdefghijklmnop")!=0) return(25);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
#endif //HAVE_STRLCAT
/*****************************************************************************/

/*****************************************************************************/
#ifndef HAVE_STRLCPY // Test only if own implementation is used
int test_strlcpy(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  size_t len1=256;
  char str1[len1], str2[len1];
  size_t n, m;

  strcpy(str1, ""); strcpy(str2, ""); m=0;
  if(verbose>1) printf("strlcpy('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcpy(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=0 || strcmp(str1, "")!=0) return(1);

  strcpy(str1, "xyz"); strcpy(str2, "abcdefgh"); m=0;
  if(verbose>1) printf("strlcpy('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcpy(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=8 || strcmp(str1, "xyz")!=0) return(11);

  strcpy(str1, "xyz"); strcpy(str2, "abcdefgh"); m=7;
  if(verbose>1) printf("strlcpy('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcpy(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=8 || strcmp(str1, "abcdef")!=0) return(12);

  strcpy(str1, ""); strcpy(str2, "abcdefgh"); m=8;
  if(verbose>1) printf("strlcpy('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcpy(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=8 || strcmp(str1, "abcdefg")!=0) return(13);

  strcpy(str1, ""); strcpy(str2, "abcdefgh"); m=9;
  if(verbose>1) printf("strlcpy('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcpy(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=8 || strcmp(str1, "abcdefgh")!=0) return(14);

  strcpy(str1, "xyz"); strcpy(str2, "abcdefgh"); m=len1;
  if(verbose>1) printf("strlcpy('%s', '%s', %zu)\n", str1, str2, m);
  n=strlcpy(str1, str2, m);
  if(verbose>1) printf("-> n=%zu str1='%s'\n", n, str1);
  if(n!=8 || strcmp(str1, "abcdefgh")!=0) return(15);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
#endif //HAVE_STRLCPY
/*****************************************************************************/

/*****************************************************************************/
int test_strIsSpaceOnly(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str1[256];
  int ret=0;

  ret=strIsSpaceOnly(NULL);
  if(ret!=1) return(1);

  strcpy(str1, "");
  ret=strIsSpaceOnly(str1);
  if(ret!=1) return(2);

  strcpy(str1, "bim bam bum");
  ret=strIsSpaceOnly(str1);
  if(ret!=0) return(3);

  strcpy(str1, "bim\tbam\tbum");
  ret=strIsSpaceOnly(str1);
  if(ret!=0) return(4);

  strcpy(str1, " ");
  ret=strIsSpaceOnly(str1);
  if(ret!=1) return(5);

  strcpy(str1, "\t");
  ret=strIsSpaceOnly(str1);
  if(ret!=1) return(6);

  strcpy(str1, "\t \t \t ");
  ret=strIsSpaceOnly(str1);
  if(ret!=1) return(7);

  strcpy(str1, "\t \t \t \r\n");
  ret=strIsSpaceOnly(str1);
  if(ret!=1) return(8);
    
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strdelstr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;

  cptr=strdelstr(NULL, NULL); if(cptr!=NULL) return(1);

  char s1[256], s2[256], s3[256];

  strcpy(s1, ""); strcpy(s2, ""); strcpy(s3, "");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, s3)) return(2);

  strcpy(s1, "ekatokakolmas"); strcpy(s2, ""); strcpy(s3, "ekatokakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, s3)) return(3);

  strcpy(s1, "ekatokakolmas"); strcpy(s2, "toka"); strcpy(s3, "ekakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "kolmas")) return(4);

  strcpy(s1, "ekatokakolmas"); strcpy(s2, "eka"); strcpy(s3, "tokakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "tokakolmas")) return(5);

  strcpy(s1, "ekatokakolmas"); strcpy(s2, "kolmas"); strcpy(s3, "ekatoka");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "")) return(6);

  strcpy(s1, "kolmas"); strcpy(s2, "ekatokakolmas"); strcpy(s3, "kolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, s3)) return(7);


  strcpy(s1, "ekatokakolmas"); strcpy(s2, "TOKA"); strcpy(s3, "ekakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "kolmas")) return(11);

  strcpy(s1, "ekaTOKAkolmas"); strcpy(s2, "toka"); strcpy(s3, "ekakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "kolmas")) return(12);


  strcpy(s1, "ekatokakolmas"); strcpy(s2, "k"); strcpy(s3, "eatokakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "atokakolmas")) return(21);

  strcpy(s1, "ekatokakolmas"); strcpy(s2, "s"); strcpy(s3, "ekatokakolma");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "")) return(22);

  strcpy(s1, "eka toka kolmas"); strcpy(s2, " toka "); strcpy(s3, "ekakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "kolmas")) return(23);

  strcpy(s1, "eka_toka_kolmas"); strcpy(s2, "_toka_"); strcpy(s3, "ekakolmas");
  if(verbose>1) {printf("s1='%s' s2='%s'", s1, s2); fflush(stdout);}
  cptr=strdelstr(s1, s2);
  if(verbose>1) {printf(" -> s1='%s' cptr='%s'\n", s1, cptr); fflush(stdout);}
  if(strcmp(s1, s3) || strcmp(cptr, "kolmas")) return(24);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strTrimLeft(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;
  size_t t;

  t=0; cptr=strTrimLeft(NULL, t); if(cptr!=NULL) return(1);

  char s1[256], s2[256];

  strcpy(s1, ""); strcpy(s2, ""); t=0;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(2);

  strcpy(s1, ""); strcpy(s2, ""); t=1;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(3);

  strcpy(s1, ""); strcpy(s2, ""); t=10;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(4);


  strcpy(s1, "012"); strcpy(s2, "012"); t=0;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(11);

  strcpy(s1, "012"); strcpy(s2, "12"); t=1;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(12);

  strcpy(s1, "012"); strcpy(s2, "2"); t=2;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(13);

  strcpy(s1, "012"); strcpy(s2, ""); t=3;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(14);

  strcpy(s1, "012"); strcpy(s2, ""); t=4;
  if(verbose>1) {printf("s1='%s' t=%zu", s1, t); fflush(stdout);}
  cptr=strTrimLeft(s1, t);
  if(verbose>1) {printf(" -> s1='%s'\n", s1); fflush(stdout);}
  if(strcmp(s1, s2) || strcmp(cptr, s2)) return(15);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strEncodeForXML(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("testing with NULL\n"); fflush(stdout);}
  if(strEncodeForXML(NULL)!=NULL) return(1);

  char s1[256], s2[256];

  if(verbose>1) {printf("testing with strings that do not need encoding\n"); fflush(stdout);}

  strcpy(s1, ""); if(strEncodeForXML(s1)!=NULL) return(2);
  strcpy(s1, " "); if(strEncodeForXML(s1)!=NULL) return(3);
  strcpy(s1, "abcdefg"); if(strEncodeForXML(s1)!=NULL) return(4);

  char *so;

  if(verbose>1) {printf("testing with strings that need encoding\n"); fflush(stdout);}

  strcpy(s1, "a&b"); strcpy(s2, "a&amp;b"); so=strEncodeForXML(s1);
  if(so==NULL) return(11);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, so); fflush(stdout);}
  if(strcmp(so, s2)!=0) {free(so); return(11);}
  free(so); 

  strcpy(s1, "a<b; c>b"); strcpy(s2, "a&lt;b; c&gt;b"); so=strEncodeForXML(s1);
  if(so==NULL) return(12);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, so); fflush(stdout);}
  if(strcmp(so, s2)!=0) {free(so); return(12);}
  free(so); 

  strcpy(s1, "str='ABC'"); strcpy(s2, "str=&apos;ABC&apos;"); so=strEncodeForXML(s1);
  if(so==NULL) return(13);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, so); fflush(stdout);}
  if(strcmp(so, s2)!=0) {free(so); return(13);}
  free(so); 

  strcpy(s1, "str=\"ABC\""); strcpy(s2, "str=&quot;ABC&quot;"); so=strEncodeForXML(s1);
  if(so==NULL) return(14);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, so); fflush(stdout);}
  if(strcmp(so, s2)!=0) {free(so); return(14);}
  free(so); 

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_strCleanForXML(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("testing with NULL\n"); fflush(stdout);}
  strCleanForXML(NULL);

  char s1[256], s2[256];

  if(verbose>1) {printf("testing with strings that do not need encoding\n"); fflush(stdout);}

  strcpy(s1, ""); strcpy(s2, ""); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(2);

  strcpy(s1, " "); strcpy(s2, " "); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(3);

  strcpy(s1, "abcdef"); strcpy(s2, "abcdef"); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(4);

  if(verbose>1) {printf("testing with strings that need encoding\n"); fflush(stdout);}

  strcpy(s1, "a&b"); strcpy(s2, "a-b"); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(11);

  strcpy(s1, "a<b; c>b"); strcpy(s2, "a-b; c-b"); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(12);

  strcpy(s1, "str='ABC'"); strcpy(s2, "str=-ABC-"); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(13);

  strcpy(s1, "str=\"ABC\""); strcpy(s2, "str=-ABC-"); strCleanForXML(s1);
  if(verbose>1) {printf("s1='%s' -> '%s'\n", s1, s2); fflush(stdout);}
  if(strcmp(s1, s2)!=0) return(14);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
