/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcfileutil.h"
/*****************************************************************************/

/*****************************************************************************/
int test_fileBackup(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[FILENAME_MAX], fname2[FILENAME_MAX], buf[64];
  FILE *fp;

  if(verbose>1) printf("\nTrying with NULL input...\n");
  ret=fileBackup(NULL, NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);

  if(verbose>1) printf("\nerror msg with NULL input...\n");
  ret=fileBackup(NULL, NULL, buf);
  if(ret==0) return(2);
  if(verbose>2) printf(" -> '%s'\n", buf);
  if(strlen(buf)<5) return(3);

  if(verbose>1) printf("\nTrying with non-existing file...\n");
  strcpy(fname, "nonexisting.txt");
  ret=fileBackup(fname, NULL, buf);
  if(ret!=0) return(10);
  if(verbose>2) printf(" -> '%s'\n", buf);
  if(strcasecmp(buf, "file does not pre-exist")) return(11);

  if(verbose>1) printf("\nTrying with existing file...\n");
  strcpy(fname, "existing.txt");
  fp=fopen(fname, "w"); fclose(fp);
  ret=fileBackup(fname, NULL, buf);
  if(ret!=0) return(20);
  snprintf(fname2, FILENAME_MAX, "%s%s", fname, ".bak");
  if(remove(fname2)) return(21);

  if(verbose>1) printf("\nSpecifying extension...\n");
  strcpy(fname, "existing.txt");
  fp=fopen(fname, "w"); fclose(fp);
  ret=fileBackup(fname, ".old", buf);
  if(ret!=0) return(30);
  snprintf(fname2, FILENAME_MAX, "%s%s", fname, ".old");
  if(remove(fname2)) return(31);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
