/** @file tpcfileutil.h
    @brief Header file for libtpcfileutil.
    @details Requires POSIX compatible compiler.
     The idea is to isolate system dependent functions from most of the code base
     to allow easier code changes when necessary.
    @author Vesa Oikonen
 */
#ifndef _TPCFILEUTIL_H_
#define _TPCFILEUTIL_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
/*****************************************************************************/
/* For Windows/MinGW */
#ifdef HAVE_DIRECT_H
#include <direct.h>
#endif
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcift.h"
/*****************************************************************************/

/*****************************************************************************/
/* backup */
extern int fileBackup(const char *filename, const char *backup_ext, char *status);
/*****************************************************************************/

/*****************************************************************************/
/* filexist */
extern int fileExist(const char *filename);
extern unsigned short int pathFileNr(const char *pathname);
extern unsigned short int pathFileList(const char *pathname, IFT *ift);
/*****************************************************************************/

/*****************************************************************************/
/* pathexist */
extern int pathExist(const char *pathname);
extern int pathRemove(const char *pathname);
extern int pathRemoveFiles(const char *pathname);
extern int pathCreate(const char *pathname);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCFILEUTIL */
