/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcfunc.h"
/*****************************************************************************/

/*****************************************************************************/
int test_igam(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\ntesting with invalid input\n");
  if(!isnan(igam(-1.0, -1.0))) return(1);

  if(verbose>1) {
    printf("\ntesting with valid input, comparing to results of Excel function");
    printf("\ngamma.dist(x,a,1,true)\n");
  }
  double a, x, v;

  a=2.345; x=6.789;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.985097039, 1.0E-08)) return(11);

  a=1.0; x=1.0;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.632120559, 1.0E-08)) return(12);

  a=0.5; x=0.5;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.682689492, 1.0E-08)) return(13);

  a=3.0; x=0.0;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.0, 1.0E-08)) return(14);

  a=0.1; x=2.0;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.994326176, 1.0E-08)) return(15);

  a=2.0; x=0.1;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.00467884, 1.0E-08)) return(16);

  a=0.1; x=99999.0;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 1.0, 1.0E-08)) return(17);

  a=99999.0; x=0.1;
  if(verbose>1) printf("igam(%g, %g)\n", a, x);
  v=igam(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.0, 1.0E-08)) return(18);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_igamc(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\ntesting with invalid input\n");
  if(!isnan(igamc(-1.0, -1.0))) return(1);

  if(verbose>1) {
    printf("\ntesting with valid input, comparing to results of Excel function");
    printf("\n1-gamma.dist(x,a,1,true)\n");
  }
  double a, x, v;

  a=2.345; x=6.789;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.014902961, 1.0E-08)) return(11);

  a=1.0; x=1.0;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.367879441, 1.0E-08)) return(12);

  a=0.5; x=0.5;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.317310508, 1.0E-08)) return(13);

  a=3.0; x=0.0;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 1.0, 1.0E-08)) return(14);

  a=0.1; x=2.0;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.005673824, 1.0E-08)) return(15);

  a=2.0; x=0.1;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.99532116, 1.0E-08)) return(16);

  a=0.1; x=99999.0;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 0.0, 1.0E-08)) return(17);

  a=99999.0; x=0.1;
  if(verbose>1) printf("igamc(%g, %g)\n", a, x);
  v=igamc(a, x); if(verbose>1) printf("  = %g\n", v);
  if(!doubleMatch(v, 1.0, 1.0E-08)) return(18);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
