/** @file tpcfunc.h
 *  @brief Header file for libtpcfunc.
 *  @author Vesa Oikonen
 */
#ifndef _TPCFUNC_H_
#define _TPCFUNC_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcmodels.h"
/*****************************************************************************/

/*****************************************************************************/
/* func */
extern int mfEvalY(
  const char *fid, const int parNr, double *p,
  const int sampleNr, double *x, double *y,
  const int verbose
);
extern int mfEvalInt(
  const char *fid, const int parNr, double *p,
  const int sampleNr, double *x, double *i,
  const int verbose
);
extern int mfEval2ndInt(
  const char *fid, const int parNr, double *p,
  const int sampleNr, double *x, double *i,
  const int verbose
);
extern int mfEvalFrameY(
  const char *fid, const int parNr, double *p,
  const int sampleNr, double *x1, double *x2, double *y,
  const int verbose
);
extern int mfEvalIntToInf(
  const char *fid, const int parNr, double *p,
  double x, double *v,
  const int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* rgamma */
extern double igam(double a, double x);
extern double igamc(double a, double x);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCFUNC */
