/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
int test_imgReadDICOM(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgWriteDICOM(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Create test image data to write */
  if(verbose>1) {printf("\nMaking test image data\n"); fflush(stdout);}
  IMG img; imgInit(&img);
  if(create_img(&img, 10, 20, 20, 3)) return(100);

  /* Write the test image */
  if(verbose>1) {printf("\n removing any old files\n"); fflush(stdout);}
  dcmFileRemove("imgWriteDICOM", NULL); remove("imgWriteDICOM");
  if(verbose>1) {printf("\nWriting test image...\n"); fflush(stdout);}
  if(imgWriteDICOM(&img, "imgWriteDICOM", status)!=TPCERROR_OK) {imgFree(&img); return(101);}


  imgFree(&img);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
