/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
int test_imgFillOHeader(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  ret=imgFillOHeader(NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==TPCERROR_OK) return(1);

  IMG img; imgInit(&img);

  ret=imgFillOHeader(&img, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret!=TPCERROR_NO_DATA) return(2);

  /* Make test data with a single plane and frame, no header */
  if(verbose>1) printf("\n making test image data.\n");
  if(create_img(&img, 1, 32, 32, 1)!=TPCERROR_OK) return(10);
  if(verbose>2) imgContents(&img, stdout);

  ret=imgFillOHeader(&img, NULL);
  if(ret!=TPCERROR_OK) {imgFree(&img); return(11);}
  if(iftFindPair(&img.oh, "isotope", "C-11", 0)<0) {imgFree(&img); return(12);}



  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
