/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcisotope.h"
/*****************************************************************************/

/*****************************************************************************/
int test_decayDescr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  decaycorrection dc;
  char *cptr;

  dc=0; if(verbose>1) printf("dc := %d\n", dc);
  cptr=decayDescr(dc);
  if(verbose>2) printf("  -> decay correction := %s\n", cptr);
  if(strcmp(cptr, "unknown")!=0) return(1);

  dc=9999; if(verbose>1) printf("dc := %d\n", dc);
  cptr=decayDescr(dc);
  if(verbose>2) printf("  -> decay correction := %s\n", cptr);
  if(strcasecmp(cptr, "unknown")!=0) return(2);

  dc=3; if(verbose>1) printf("dc := %d\n", dc);
  cptr=decayDescr(dc);
  if(verbose>2) printf("  -> decay correction := %s\n", cptr);
  if(strcasecmp(cptr, "corrected to scan start time")!=0) return(3);
  
  dc=4; if(verbose>1) printf("dc := %d\n", dc);
  cptr=decayDescr(dc);
  if(verbose>2) printf("  -> decay correction := %s\n", cptr);
  if(strcasecmp(cptr, "corrected to administration time")!=0) return(4);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_lambdaFromHalflife(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  double hl, lambda;

  hl=0.0; if(verbose>1) printf("halflife := %g\n", hl);
  lambda=lambdaFromHalflife(hl);
  if(verbose>2) printf("  -> lambda := %g\n", lambda);
  if(!isnan(lambda)) return(1);

  hl=nan(""); if(verbose>1) printf("halflife := %g\n", hl);
  lambda=lambdaFromHalflife(hl);
  if(verbose>2) printf("  -> lambda := %g\n", lambda);
  if(!isnan(lambda)) return(2);

  hl=M_LN2; if(verbose>1) printf("halflife := %g\n", hl);
  lambda=lambdaFromHalflife(hl);
  if(verbose>2) printf("  -> lambda := %g\n", lambda);
  if(fabs(lambda-1.0)>1.0E-20) return(3);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_lambdaFromIsotope(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  double lambda;
  int isotope;

  isotope=ISOTOPE_UNKNOWN;
  if(verbose>1) printf("isotope := %s\n", isotopeName(isotope));
  lambda=lambdaFromIsotope(isotope);
  if(verbose>2) printf("  -> lambda := %g\n", lambda);
  if(!isnan(lambda)) return(1);

  isotope=99999;
  if(verbose>1) printf("isotope := %s\n", isotopeName(isotope));
  lambda=lambdaFromIsotope(isotope);
  if(verbose>2) printf("  -> lambda := %g\n", lambda);
  if(!isnan(lambda)) return(2);

  isotope=ISOTOPE_C_11;
  if(verbose>1) printf("isotope := %s\n", isotopeName(isotope));
  lambda=lambdaFromIsotope(isotope);
  if(verbose>2) printf("  -> lambda := %g\n", lambda);
  if(fabs(lambda-0.0339778)>1.0E-06) return(3);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_decayCorrectionFactorFromLambda(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  double f, lambda, starttime, duration;

  lambda=nan(""); starttime=nan(""); duration=nan("");
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(!isnan(f)) return(1);

  lambda=0.0; starttime=0.0; duration=0.0;
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(!isnan(f)) return(2);

  lambda=1.0; starttime=0.0; duration=0.0;
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-1.0)>1.0E-06) return(3);

  lambda=-1.0; starttime=0.0; duration=0.0;
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-1.0)>1.0E-06) return(4);

  lambda=lambdaFromIsotope(ISOTOPE_C_11);
  starttime=2.0*isotopeHalflife(ISOTOPE_C_11); duration=0.0;
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-4.0)>1.0E-06) return(5);

  lambda=-lambdaFromIsotope(ISOTOPE_C_11);
  starttime=isotopeHalflife(ISOTOPE_C_11); duration=0.0;
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-0.5)>1.0E-06) return(6);

  lambda=lambdaFromIsotope(ISOTOPE_O_15);
  starttime=isotopeHalflife(ISOTOPE_O_15); duration=2.0*isotopeHalflife(ISOTOPE_O_15);
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-3.696785)>2.0E-06) return(7);

  lambda=-lambdaFromIsotope(ISOTOPE_O_15);
  starttime=isotopeHalflife(ISOTOPE_O_15); duration=2.0*isotopeHalflife(ISOTOPE_O_15);
  if(verbose>1) {
    printf("lambda := %g\n", lambda);
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromLambda(lambda, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-0.270505)>2.0E-06) return(8);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_decayCorrectionFactorFromIsotope(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  double f, starttime, duration;
  int isotope;

  isotope=ISOTOPE_UNKNOWN; starttime=nan(""); duration=nan("");
  if(verbose>1) {
    printf("isotope := %s\n", isotopeName(isotope));
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromIsotope(isotope, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(!isnan(f)) return(1);

  isotope=ISOTOPE_F_18; starttime=0.0; duration=0.0;
  if(verbose>1) {
    printf("isotope := %s\n", isotopeName(isotope));
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromIsotope(isotope, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-1.0)>1.0E-06) return(2);

  isotope=ISOTOPE_C_11; starttime=2.0*isotopeHalflife(ISOTOPE_C_11); duration=0.0;
  if(verbose>1) {
    printf("isotope := %s\n", isotopeName(isotope));
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromIsotope(isotope, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-4.0)>1.0E-06) return(5);

  isotope=ISOTOPE_O_15;
  starttime=isotopeHalflife(ISOTOPE_O_15); duration=2.0*isotopeHalflife(ISOTOPE_O_15);
  if(verbose>1) {
    printf("isotope := %s\n", isotopeName(isotope));
    printf("starttime := %g\n", starttime);
    printf("duration := %g\n", duration);
  }
  f=decayCorrectionFactorFromIsotope(isotope, starttime, duration);
  if(verbose>2) printf("  -> decay_correction_factor := %g\n", f);
  if(fabs(f-3.696785)>2.0E-06) return(7);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
