/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpclinopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_fitLine(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int n=fitLine(NULL, NULL, 0, NULL, NULL); if(n!=0) return(1);
  double x[10], y[10], slope, ic;
  n=fitLine(x, y, 0, &slope, &ic); if(n!=0) return(2);

  for(int i=0; i<10; i++) {x[i]=(double)(i-1); y[i]=(double)(i);}
  n=fitLine(x, y, 2, &slope, &ic);
  if(n!=2 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(11);
  n=fitLine(x, y, 2, NULL, &ic);
  if(n!=2 || !doubleMatch(ic, 1.0, 1.0E-10)) return(12);
  n=fitLine(x, y, 2, &slope, NULL);
  if(n!=2 || !doubleMatch(slope, 1.0, 1.0E-10)) return(13);
  n=fitLine(x, y, 2, NULL, NULL);
  if(n!=2) return(14);
  n=fitLine(x, y, 10, &slope, &ic);
  if(n!=10 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(15);
  x[5]=y[5]=nan("");
  n=fitLine(x, y, 10, &slope, &ic);
  if(n!=9 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(16);
  x[0]=nan("");
  n=fitLine(x, y, 10, &slope, &ic);
  if(n!=8 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(17);
  y[8]=nan("");
  n=fitLine(x, y, 10, &slope, &ic);
  if(n!=7 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(18);

  for(int i=0; i<10; i++) {x[i]=nan(""); y[i]=(double)(i);}
  n=fitLine(x, y, 10, &slope, &ic);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(21);
  for(int i=0; i<10; i++) {x[i]=(double)i; y[i]=nan("");}
  n=fitLine(x, y, 10, &slope, &ic);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(22);

  for(int i=0; i<10; i++) {x[i]=0.0; y[i]=0.0;}
  n=fitLine(x, y, 10, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(31);
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(32);
  n=fitLine(x, y, 1, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(33);
  x[0]=nan("");
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(34);

  for(int i=0; i<10; i++) {x[i]=(double)(i-2); y[i]=5.0;}
  n=fitLine(x, y, 10, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=10 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 5.0, 1.0E-10)) return(41);
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=2 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 5.0, 1.0E-10)) return(42);
  n=fitLine(x, y, 1, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=1 || !doubleMatch(slope, -2.5, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(43);
  y[0]=nan("");
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=1 || !doubleMatch(slope, -5.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(44);

  for(int i=0; i<10; i++) {x[i]=(double)(i-2); y[i]=0.0;}
  n=fitLine(x, y, 10, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=10 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(51);
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=2 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(52);
  n=fitLine(x, y, 1, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=1 || !doubleMatch(slope, 0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(53);
  y[0]=nan("");
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=1 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(54);

  for(int i=0; i<5; i++) {x[i]=(double)(i-10); y[i]=1.0;}
  for(int i=5; i<10; i++) {x[i]=(double)(i+1); y[i]=-1.0;}
  //if(verbose>2) for(int i=0; i<10; i++) printf("\t%g\t%g\n", x[i], y[i]);
  n=fitLine(x, y, 10, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=10 || !doubleMatch(slope, -0.1212121212, 1.0E-06) || !doubleMatch(ic, 0.0, 1.0E-10)) return(61);

  for(int i=0; i<5; i++) {x[i]=-10; y[i]=(double)(-i);}
  for(int i=5; i<10; i++) {x[i]=+10; y[i]=(double)(i);}
  //if(verbose>2) for(int i=0; i<10; i++) printf("\t%g\t%g\n", x[i], y[i]);
  n=fitLine(x, y, 10, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=10 || !doubleMatch(slope, 0.45, 1.0E-06) || !doubleMatch(ic, 2.5, 1.0E-10)) return(62);
  n=fitLine(x, y, 2, &slope, &ic); //if(verbose>2) printf("slope=%g ic=%g n=%d\n", slope, ic, n);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(63);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fitLinePearson(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int n=fitLinePearson(NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL); if(n!=0) return(1);


  if(verbose>1) printf("testing only slope and intercepts\n");

  double x[10], y[10], slope, ic, xic;
  n=fitLinePearson(x, y, 0, &slope, NULL, &ic, NULL, NULL, NULL, NULL, NULL); if(n!=0) return(2);

  for(int i=0; i<10; i++) {x[i]=(double)(i-1); y[i]=(double)(i);}
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=2 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(11);
  if(!doubleMatch(xic, -1.0, 1.0E-10)) return(11);
  n=fitLinePearson(x, y, 2, NULL, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=2 || !doubleMatch(ic, 1.0, 1.0E-10)) return(12);
  if(!doubleMatch(xic, -1.0, 1.0E-10)) return(12);
  n=fitLinePearson(x, y, 2, &slope, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
  if(n!=2 || !doubleMatch(slope, 1.0, 1.0E-10)) return(13);
  n=fitLinePearson(x, y, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
  if(n!=2) return(14);
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=10 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(15);
  if(!doubleMatch(xic, -1.0, 1.0E-10)) return(15);
  x[5]=y[5]=nan("");
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=9 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(16);
  if(!doubleMatch(xic, -1.0, 1.0E-10)) return(16);
  x[0]=nan("");
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=8 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(17);
  if(!doubleMatch(xic, -1.0, 1.0E-10)) return(17);
  y[8]=nan("");
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=7 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(18);
  if(!doubleMatch(xic, -1.0, 1.0E-10)) return(18);

  for(int i=0; i<10; i++) {x[i]=nan(""); y[i]=(double)(i);}
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(21);
  for(int i=0; i<10; i++) {x[i]=(double)i; y[i]=nan("");}
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(22);

  for(int i=0; i<10; i++) {x[i]=0.0; y[i]=0.0;}
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(31);
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(32);
  n=fitLinePearson(x, y, 1, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(33);
  x[0]=nan("");
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(34);

  for(int i=0; i<10; i++) {x[i]=(double)(i-2); y[i]=5.0;}
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=10 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 5.0, 1.0E-10)) return(41);
  if(!isnan(xic)) return(41);
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=2 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 5.0, 1.0E-10)) return(42);
  if(!isnan(xic)) return(42);
  n=fitLinePearson(x, y, 1, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=1 || !doubleMatch(slope, -2.5, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(43);
  if(!doubleMatch(xic, 0.0, 1.0E-10)) return(43);
  y[0]=nan("");
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=1 || !doubleMatch(slope, -5.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(44);
  if(!doubleMatch(xic, 0.0, 1.0E-10)) return(44);

  for(int i=0; i<10; i++) {x[i]=(double)(i-2); y[i]=0.0;}
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=10 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(51);
  if(!isnan(xic)) return(51);
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=2 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(52);
  if(!isnan(xic)) return(52);
  n=fitLinePearson(x, y, 1, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(verbose>3) printf("%g %g %g\n", slope, ic, xic);
  if(n!=1 || !doubleMatch(slope, 0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(53);
  if(!isnan(xic)) return(53);
  y[0]=nan("");
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=1 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(54);
  if(!isnan(xic)) return(54);

  for(int i=0; i<5; i++) {x[i]=(double)(i-10); y[i]=1.0;}
  for(int i=5; i<10; i++) {x[i]=(double)(i+1); y[i]=-1.0;}
  //if(verbose>2) for(int i=0; i<10; i++) printf("\t%g\t%g\n", x[i], y[i]);
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=10 || !doubleMatch(slope, -0.1212121212, 1.0E-06) || !doubleMatch(ic, 0.0, 1.0E-10)) return(61);
  if(!doubleMatch(xic, -ic/slope, 1.0E-08)) return(61);

  for(int i=0; i<5; i++) {x[i]=-10; y[i]=(double)(-i);}
  for(int i=5; i<10; i++) {x[i]=+10; y[i]=(double)(i);}
  //if(verbose>2) for(int i=0; i<10; i++) printf("\t%g\t%g\n", x[i], y[i]);
  n=fitLinePearson(x, y, 10, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=10 || !doubleMatch(slope, 0.45, 1.0E-06) || !doubleMatch(ic, 2.5, 1.0E-10)) return(62);
  if(!doubleMatch(xic, -ic/slope, 1.0E-08)) return(62);
  n=fitLinePearson(x, y, 2, &slope, NULL, &ic, NULL, &xic, NULL, NULL, NULL);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic)) return(63);


  if(verbose>1) printf("testing also error calculations\n");

  double sd_slope, sd_ic, sd_xic, r, sd_y;

  for(int i=0; i<10; i++) {x[i]=(double)(i-1); y[i]=(double)(i);}

  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=2 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(101);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(101);
  if(!doubleMatch(xic, -1.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(101);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(101);

  n=fitLinePearson(x, y, 2, NULL, &sd_slope, NULL, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=2) return(14);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(102);
  if(!doubleMatch(xic, -1.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(102);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(102);

  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=10 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(103);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(103);
  if(!doubleMatch(xic, -1.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(103);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(103);

  x[5]=y[5]=nan("");
  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=9 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(104);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(104);
  if(!doubleMatch(xic, -1.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(104);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(104);

  x[0]=nan("");
  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=8 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(105);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(105);
  if(!doubleMatch(xic, -1.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(105);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(105);

  y[8]=nan("");
  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=7 || !doubleMatch(slope, 1.0, 1.0E-10) || !doubleMatch(ic, 1.0, 1.0E-10)) return(106);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(106);
  if(!doubleMatch(xic, -1.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(106);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(106);


  for(int i=0; i<10; i++) {x[i]=nan(""); y[i]=(double)(i);}

  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic) || !isnan(sd_xic)) return(111);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(112);
  for(int i=0; i<10; i++) {x[i]=(double)i; y[i]=nan("");}
  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic) || !isnan(sd_xic)) return(113);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(114);

  for(int i=0; i<10; i++) {x[i]=0.0; y[i]=0.0;}

  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic) || !isnan(sd_xic)) return(121);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(122);
  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic) || !isnan(sd_xic)) return(123);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(124);
  n=fitLinePearson(x, y, 1, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic) || !isnan(sd_xic)) return(125);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(126);
  x[0]=nan("");
  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic) || !isnan(xic) || !isnan(sd_xic)) return(127);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(128);

  for(int i=0; i<10; i++) {x[i]=(double)(i-2); y[i]=5.0;}

  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=10 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 5.0, 1.0E-10)) return(131);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(131);
  if(!doubleMatch(r, 0.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(131);
  if(!isnan(xic) || !isnan(sd_xic)) return(131);

  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=2 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 5.0, 1.0E-10)) return(132);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(132);
  if(!doubleMatch(r, 0.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(132);
  if(!isnan(xic) || !isnan(sd_xic)) return(132);

  n=fitLinePearson(x, y, 1, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=1 || !doubleMatch(slope, -2.5, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(133);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(133);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(133);
  if(!doubleMatch(xic, 0.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(133);

  y[0]=nan("");
  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=1 || !doubleMatch(slope, -5.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(134);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(134);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(134);
  if(!doubleMatch(xic, 0.0, 1.0E-10) || !doubleMatch(sd_xic, 0.0, 1.0E-10)) return(134);

  for(int i=0; i<10; i++) {x[i]=(double)(i-2); y[i]=0.0;}

  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=10 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(141);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(141);
  if(!doubleMatch(r, 0.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(141);
  if(!isnan(xic) || !isnan(sd_xic)) return(141);

  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(n!=2 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(142);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(142);
  if(!doubleMatch(r, 0.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(142);
  if(!isnan(xic) || !isnan(sd_xic)) return(142);

  n=fitLinePearson(x, y, 1, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=1 || !doubleMatch(slope, 0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(143);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(143);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(143);
  if(!isnan(xic) || !isnan(sd_xic)) return(143);

  y[0]=nan("");
  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=1 || !doubleMatch(slope, 0.0, 1.0E-10) || !doubleMatch(ic, 0.0, 1.0E-10)) return(144);
  if(!doubleMatch(sd_slope, 0.0, 1.0E-10) || !doubleMatch(sd_ic, 0.0, 1.0E-10)) return(144);
  if(!doubleMatch(r, 1.0, 1.0E-10) || !doubleMatch(sd_y, 0.0, 1.0E-10)) return(144);
  if(!isnan(xic) || !isnan(sd_xic)) return(144);


  for(int i=0; i<5; i++) {x[i]=(double)(i-10); y[i]=1.0;}
  for(int i=5; i<10; i++) {x[i]=(double)(i+1); y[i]=-1.0;}

  if(verbose>2) for(int i=0; i<10; i++) printf("\t%g\t%g\n", x[i], y[i]);
  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  // correct values from Excel correlation analysis
  if(n!=10 || !doubleMatch(slope, -0.1212121212, 1.0E-08) || !doubleMatch(ic, 0.0, 1.0E-10)) return(151);
  if(!doubleMatch(sd_slope, 0.007575758, 1.0E-09) || !doubleMatch(sd_ic, 0.061545745, 1.0E-09)) return(152);
  if(!doubleMatch(r, 0.987218625, 1.0E-09) || !doubleMatch(sd_y, 0.194624736, 1.0E-09)) return(153);
  if(!doubleMatch(xic, -ic/slope, 1.0E-09)) return(154);

  for(int i=0; i<5; i++) {x[i]=-10; y[i]=(double)(-i);}
  for(int i=5; i<10; i++) {x[i]=+10; y[i]=(double)(i);}

  if(verbose>2) for(int i=0; i<10; i++) printf("\t%g\t%g\n", x[i], y[i]);
  n=fitLinePearson(x, y, 10, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=10 || !doubleMatch(slope, 0.45, 1.0E-06) || !doubleMatch(ic, 2.5, 1.0E-10)) return(161);
  if(!doubleMatch(sd_slope, 0.05, 1.0E-10) || !doubleMatch(sd_ic, 0.5, 1.0E-10)) return(162);
  if(!doubleMatch(r, 0.961144145, 1.0E-09) || !doubleMatch(sd_y, 1.58113883, 1.0E-09)) return(163);
  if(!doubleMatch(xic, -ic/slope, 1.0E-09)) return(164);

  n=fitLinePearson(x, y, 2, &slope, &sd_slope, &ic, &sd_ic, &xic, &sd_xic, &r, &sd_y);
  if(verbose>2) printf("%g %g %g %g %g %g %g %g\n", slope, sd_slope, ic, sd_ic, xic, sd_xic, r, sd_y);
  if(n!=0 || !isnan(slope) || !isnan(ic)) return(166);
  if(!isnan(sd_slope) || !isnan(sd_ic) || !isnan(r) || !isnan(sd_y)) return(167);
  if(!isnan(xic) || !isnan(sd_xic)) return(168);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_highestSlope(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("testing with NULL input\n");
  if(highestSlope(NULL, NULL, 0, 0, 0.0, NULL, NULL, NULL, NULL)==0) return(1);
  if(verbose>2) printf("   ... good, did not crash.\n");

  {
  int n=20;
  double x[n], y[n];
  for(int i=0; i<n; i++) x[i]=y[i]=nan("");
  if(highestSlope(x, y, n, 3, nan(""), NULL, NULL, NULL, NULL)==0) return(2);
  if(verbose>2) printf("   ... good, did not crash.\n");
  double slope, yi, xi, xh;
  if(highestSlope(x, y, n, 3, nan(""), &slope, &yi, &xi, &xh)==0) return(3);
  if(verbose>2) printf("   ... good, did not crash.\n");
  if(!isnan(slope) || !isnan(yi) || !isnan(xi) || !isnan(xh)) return(4);
  }

  if(verbose>1) printf("testing with reasonable input\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  {
  int i, n=18;
  double x[n], y[n];
  i=0; x[i]=0.0; y[i]=0.0;
  i++; x[i]=1.0; y[i]=0.0;
  i++; x[i]=2.0; y[i]=10.0;
  i++; x[i]=3.0; y[i]=10.0;
  i++; x[i]=4.0; y[i]=10.0;
  i++; x[i]=5.0; y[i]=10.0;
  i++; x[i]=6.0; y[i]=10.0;
  i++; x[i]=7.0; y[i]=10.0;
  i++; x[i]=8.0; y[i]=10.0;
  i++; x[i]=9.0; y[i]=10.0;
  i++; x[i]=10.0; y[i]=10.0;
  i++; x[i]=20.0; y[i]=20.0;
  i++; x[i]=30.0; y[i]=30.0;
  i++; x[i]=40.0; y[i]=40.0;
  i++; x[i]=50.0; y[i]=50.0;
  i++; x[i]=60.0; y[i]=50.0;
  i++; x[i]=70.0; y[i]=40.0;
  i++; x[i]=100.0; y[i]=30.0;
  if(verbose>3) for(int i=0; i<n; i++) printf("\t%g\t%g\n", x[i], y[i]);

  double slope, yi, xi, xh;

  if(highestSlope(x, y, n, 2, nan(""), &slope, &yi, &xi, &xh)) return(101);
  if(verbose>2) printf("-> %g %g %g %g\n", slope, yi, xi, xh);
  if(!doubleMatch(slope, 10., 1.0E-10)) return(102);
  if(!doubleMatch(yi, -10., 1.0E-10)) return(103);
  if(!doubleMatch(xi, 1., 1.0E-10)) return(104);
  if(!doubleMatch(xh, 1.5, 1.0E-10)) return(105);

  if(highestSlope(x, y, n, 2, 2.5, &slope, &yi, &xi, &xh)) return(111);
  if(verbose>2) printf("-> %g %g %g %g\n", slope, yi, xi, xh);
  if(!doubleMatch(slope, 1., 1.0E-10)) return(112);
  if(!doubleMatch(yi, 0., 1.0E-10)) return(113);
  if(!doubleMatch(xi, 0., 1.0E-10)) return(114);
  if(!doubleMatch(xh, 15., 1.0E-10)) return(115);

  if(highestSlope(x, y, n, 5, 2.0, &slope, &yi, &xi, &xh)) return(121);
  if(verbose>2) printf("-> %g %g %g %g\n", slope, yi, xi, xh);
  if(!doubleMatch(slope, 1., 1.0E-10)) return(122);
  if(!doubleMatch(yi, 0., 1.0E-10)) return(123);
  if(!doubleMatch(xi, 0., 1.0E-10)) return(124);
  if(!doubleMatch(xh, 30., 1.0E-10)) return(125);

  y[12]=nan("");
  if(highestSlope(x, y, n, 4, 2.0, &slope, &yi, &xi, &xh)) return(131);
  if(verbose>2) printf("-> %g %g %g %g\n", slope, yi, xi, xh);
  if(!doubleMatch(slope, 1., 1.0E-10)) return(132);
  if(!doubleMatch(yi, 0., 1.0E-10)) return(133);
  if(!doubleMatch(xi, 0., 1.0E-10)) return(134);
  if(!doubleMatch(xh, 30., 1.0E-10)) return(135);
  y[12]=30.0;

  if(highestSlope(x, y, n, 2, 50.0, &slope, &yi, &xi, &xh)) return(141);
  if(verbose>2) printf("-> %g %g %g %g\n", slope, yi, xi, xh);
  if(!doubleMatch(slope, 0., 1.0E-10)) return(142);
  if(!doubleMatch(yi, 50., 1.0E-10)) return(143);
  if(!isnan(xi)) return(144);
  if(!doubleMatch(xh, 55., 1.0E-10)) return(145);

  if(highestSlope(x, y, n, 2, 55.0, &slope, &yi, &xi, &xh)) return(151);
  if(verbose>2) printf("-> %g %g %g %g\n", slope, yi, xi, xh);
  if(!doubleMatch(slope, -0.3333333, 1.0E-05)) return(152);
  if(!doubleMatch(yi, 63.333333, 1.0E-05)) return(153);
  if(!doubleMatch(xi, 190., 1.0E-10)) return(154);
  if(!doubleMatch(xh, 85., 1.0E-10)) return(155);

  if(highestSlope(x, y, n, 4, 55.0, &slope, &yi, &xi, &xh)==0) return(161);
  if(!isnan(slope) || !isnan(yi) || !isnan(xi) || !isnan(xh)) return(162);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
