/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcmicropet.h"
/*****************************************************************************/

/*****************************************************************************/
int test_micropetHeaderRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[256];
  IFT header; iftInit(&header);

  if(verbose>1) printf("\n testing with empty input.\n");
  ret=micropetHeaderRead(NULL, NULL, status);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==TPCERROR_OK) return(1);

  fname[0]=(char)0;
  ret=micropetHeaderRead(fname, NULL, status);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n testing with non-existing file.\n");
  strcpy(fname, "nofile.img.hdr");
  ret=micropetHeaderRead(fname, &header, status);
  if(ret==TPCERROR_OK) return(3);

  if(verbose>1) printf("\n testing with real header file.\n");
  strcpy(fname, "P108731.ct.img.hdr");
  ret=micropetHeaderRead(fname, &header, status);
  if(ret!=TPCERROR_OK) return(11);
  if(verbose>10) iftWrite(&header, stdout, NULL);

  iftFree(&header);

  if(verbose>1) printf("\n testing without giving pointer to header data.\n");
  strcpy(fname, "P108731.ct.img.hdr");
  ret=micropetHeaderRead(fname, NULL, status);
  if(ret!=TPCERROR_OK) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_micropetExists(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\n testing with empty input.\n");
  if(micropetExists(NULL, NULL, NULL, NULL, status)!=0) {
    if(verbose>1) printf("  failed, but at least did not segfault.\n");
    return(1);
  }
  if(verbose>1) {printf("  ok\n"); fflush(stdout);}
  if(micropetExists("", NULL, NULL, NULL, status)!=0) {
    if(verbose>1) printf("  failed, but at least did not segfault.\n");
    return(2);
  }
  if(verbose>1) {printf("  ok\n"); fflush(stdout);}
  if(micropetExists("./", NULL, NULL, NULL, status)!=0) {
    if(verbose>1) printf("  failed, but at least did not segfault.\n");
    return(3);
  }
  if(verbose>1) {printf("  ok\n"); fflush(stdout);}


  char fname[256];

  if(verbose>1) printf("\n testing with non-existing files.\n");
  strcpy(fname, "nofile.img.hdr");
  if(verbose>1) {printf("  ok\n"); fflush(stdout);}
  if(micropetExists(fname, NULL, NULL, NULL, status)!=0) return(11);
  strcpy(fname, "nofile.img");
  if(verbose>1) {printf("  ok\n"); fflush(stdout);}
  if(micropetExists(fname, NULL, NULL, NULL, status)!=0) return(12);
  strcpy(fname, "nofile");
  if(micropetExists(fname, NULL, NULL, NULL, status)!=0) return(13);
  if(verbose>1) {printf("  ok\n"); fflush(stdout);}

  if(verbose>1) printf("\n creating dummy data file, since function is testing just that one exists.\n");
  if(!fileExist("P108731.ct.img")) {
    FILE *fp=fopen("P108731.ct.img", "w");
    fprintf(fp, "dummy file.\n");
    fclose(fp);
  }

  if(verbose>1) printf("\n testing with existing file.\n");
  strcpy(fname, "P108731.ct.img.hdr");
  if(micropetExists(fname, NULL, NULL, NULL, status)!=2) return(21);
  strcpy(fname, "P108731.ct.img");
  if(micropetExists(fname, NULL, NULL, NULL, status)!=2) return(22);
  strcpy(fname, "P108731.ct");
  if(micropetExists(fname, NULL, NULL, NULL, status)!=2) return(23);

  if(verbose>1) printf("\n storing file names.\n");
  char imgname[256], hdrname[256];
  strcpy(fname, "P108731.ct");
  if(micropetExists(fname, hdrname, imgname, NULL, status)!=2) return(31);
  if(strcmp(hdrname, "P108731.ct.img.hdr")!=0) return(32);
  if(strcmp(imgname, "P108731.ct.img")!=0) return(33);

  if(verbose>1) printf("\n storing header.\n");
  IFT header; iftInit(&header);
  strcpy(fname, "P108731.ct.img");
  if(micropetExists(fname, NULL, NULL, &header, status)!=2) {iftFree(&header); return(41);}
  if(iftFindKey(&header, "number_of_dimensions", 0)<0) {
    iftFree(&header); return(42);
  }
  iftFree(&header);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
