/******************************************************************************
 * This file is not compiled into the library, but it contains main()
 * which is compiled to an executable, used to test the library functions. 
 *****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcmodels.h"
/*****************************************************************************/
#include "tpcpar.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Usage: @P [options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " -t, --test",
  "     Run all tests for library functions.",
  0};
/*****************************************************************************/

/*****************************************************************************/
/** Run unit tests to the library functions
    @author Vesa Oikonen
    @return 0 if all tests pass, otherwise >0.
 */
int main(
  /** Nr of arguments. */
  int argc,
  /** Pointer to arrays of argument string. */
  char *argv[ ]
) {
  int i, help=0, version=0, verbose=1, error=0, test=0;
  int ret;
  char *cptr;

  if(argc==1) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  for(i=1; i<argc; i++) {
    if(tpcProcessStdOptions(argv[i], &help, &version, &verbose)==0) continue;
    cptr=argv[i]; if(*cptr=='-') cptr++; if(*cptr=='-') cptr++;
    if(strncasecmp(cptr, "TEST", 1)==0) {
      test=1; continue;
    } else {
      error++; break;
    }
  }
  if(error>0) {
    fprintf(stderr, "Error: specify --help for usage.\n");
    return(1);
  }
  /* Print help or version? */
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  if(test==0) return(0);

  if(verbose>0) printf("running tests for library functions...\n");
  TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  statusSet(&status, __func__, __FILE__, __LINE__, 0);
  i=10;
  /* par */
  i++; if((ret=test_parInit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parrInit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parnInit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parFree(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parrFree(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parrAllocate(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parAllocate(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parAllocateMore(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parEnsureNames(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsWSS(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsFitRange(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsModel(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parSDWithPar(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parCLWithPar(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsFitNr(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsDataNr(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsOptcrit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parIsStudyNr(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parSetStudyNr(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parDeletePar(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parDeleteTAC(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parcsv */
  i++; if((ret=test_parWriteCSV(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parReadCSV(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parift */
  i++; if((ret=test_parToIFT(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parWriteIFT(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parFromIFT(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parxmlio */
  i++; if((ret=test_parWriteXML(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* pario */
  i++; if((ret=test_parFormattxt(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parFormatIdentify(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parFormatFromExtension(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parDefaultExtension(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parWrite(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parRead(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parListLimits(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parWriteLimits(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parReadLimits(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parres */
  i++; if((ret=test_parPrintType(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parWriteRES(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parReadRES(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parfit */
  i++; if((ret=test_parWriteFIT(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parReadFIT(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parcomb */
  i++; if((ret=test_parSelectByAnother(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parCombineTACs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parcomp */
  i++; if((ret=test_parCompareParameterNames(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parCompareParameterUnits(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parCompareTacNames(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parCompareParameters(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parCompareWSS(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parselect */
  i++; if((ret=test_parSelectedTACs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parSelectTACs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parSelectedParameters(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parSelectParameters(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parFindParameter(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parGetParameter(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parGetParameterUnit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parValueRange(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parorder */
  i++; if((ret=test_parSortByName(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* parexample */
  i++; if((ret=test_parExampleTTACs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_parExamplePerfectBolus(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }

  if(verbose>0) printf("\nAll tests passed.\n\n");
  statusFree(&status);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
