/** @file parorder.c
 *  @brief Sort or otherwise change the order of data in PAR struct.
 */
/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
/*****************************************************************************/
#include "tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
/// @cond
/** Local function */
static int parQSortName(const void *r1, const void *r2)
{
  int res;
  res=strcasecmp( ((PARR*)r1)->name, ((PARR*)r2)->name );
  return(res);
}
/// @endcond
/** Sort TACs in alphabetical order by their TAC name.
    @return enum tpcerror (TPCERROR_OK when successful).
    @sa parSelectTACs, tacSortByName, parEnsureNames
 */
int parSortByName(
  /** Pointer to PAR struct. */
  PAR *d,
  /** Pointer to status data; enter NULL if not needed. */
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  if(verbose>0) printf("%s()\n", __func__);
  /* Check that required data exists */
  if(d==NULL) {
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_NO_DATA);
    return TPCERROR_NO_DATA;
  }
  if(d->tacNr>d->_tacNr) {
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_FAIL);
    return TPCERROR_FAIL;
  }
  statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_OK);
  if(d->tacNr<2) return TPCERROR_OK;
  qsort(d->r, d->tacNr, sizeof(PARR), parQSortName);
  return TPCERROR_OK;
}
/*****************************************************************************/

/*****************************************************************************/
