/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parCompareParameterNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parCompareParameterNames(NULL, NULL, -1, 1, status);
  if(n==0) {return 1;}
  
  PAR par1; parInit(&par1);
  PAR par2; parInit(&par2);

  if(verbose>1) printf("should not crash with empty PAR structs\n");
  n=parCompareParameterNames(&par1, &par2, -1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 2;}
  n=parCompareParameterNames(&par1, &par2, 1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 3;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_par(&par1); if(ret==TPCERROR_OK) ret=create_par(&par2);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=parCompareParameterNames(&par1, &par2, -1, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 11;}
  n=parCompareParameterNames(&par1, &par2, 0, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 12;}
  n=parCompareParameterNames(&par1, &par2, 1, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 13;}
  /* but too large index should have no match */
  n=parCompareParameterNames(&par1, &par2, 9999, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 15;}

  if(verbose>1) printf("different names should not match\n");
  strcpy(par2.n[1].name, "newname");
  n=parCompareParameterNames(&par1, &par2, -1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 21;}
  n=parCompareParameterNames(&par1, &par2, 0, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 22;}
  n=parCompareParameterNames(&par1, &par2, 1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 23;}
  n=parCompareParameterNames(&par1, &par2, 2, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 24;}
  
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par1); parFree(&par2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parCompareParameterUnits(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parCompareParameterUnits(NULL, NULL, -1, status);
  if(n==0) {return 1;}  
  
  PAR par1; parInit(&par1);
  PAR par2; parInit(&par2);

  if(verbose>1) printf("should work with empty PAR structs\n");
  n=parCompareParameterUnits(&par1, &par2, -1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 2;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_par(&par1); if(ret==TPCERROR_OK) ret=create_par(&par2); 
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=parCompareParameterUnits(&par1, &par2, -1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 11;}
  n=parCompareParameterUnits(&par1, &par2, 0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 12;}
  n=parCompareParameterUnits(&par1, &par2, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 13;}
  n=parCompareParameterUnits(&par1, &par2, 9999, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 14;}
  
  if(verbose>1) printf("different unit\n");
  par1.n[2].unit=UNIT_PER_SEC; par2.n[2].unit=UNIT_PER_MIN;
  n=parCompareParameterUnits(&par1, &par2, -1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 21;}
  n=parCompareParameterUnits(&par1, &par2, 0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 22;}
  n=parCompareParameterUnits(&par1, &par2, 2, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 23;}

  if(verbose>1) printf("match if both are unknown\n");
  par1.n[2].unit=UNIT_UNKNOWN; par2.n[2].unit=UNIT_UNKNOWN;
  n=parCompareParameterUnits(&par1, &par2, -1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 31;}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par1); parFree(&par2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parCompareTacNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parCompareTacNames(NULL, NULL, -1, 1, status);
  if(n==0) {return 1;}
  
  PAR par1; parInit(&par1);
  PAR par2; parInit(&par2);

  if(verbose>1) printf("should not crash with empty PAR structs\n");
  n=parCompareTacNames(&par1, &par2, -1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 2;}
  n=parCompareTacNames(&par1, &par2, 1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 3;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_par(&par1); if(ret==TPCERROR_OK) ret=create_par(&par2);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=parCompareTacNames(&par1, &par2, -1, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 11;}
  n=parCompareTacNames(&par1, &par2, 0, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 12;}
  n=parCompareTacNames(&par1, &par2, 1, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 13;}
  /* but too large index should have no match */
  n=parCompareTacNames(&par1, &par2, 9999, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 15;}

  if(verbose>1) printf("different names should not match\n");
  strcpy(par2.r[1].name, "newname");
  n=parCompareTacNames(&par1, &par2, -1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 21;}
  n=parCompareTacNames(&par1, &par2, 0, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 22;}
  n=parCompareTacNames(&par1, &par2, 1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 23;}
  n=parCompareTacNames(&par1, &par2, 2, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 24;}

  if(verbose>1) printf("name can be empty\n");
  strcpy(par2.r[1].name, ".");
  n=parCompareTacNames(&par1, &par2, -1, 1, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 31;}
  strcpy(par1.r[1].name, ".");
  n=parCompareTacNames(&par1, &par2, -1, 1, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 32;}

  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par1); parFree(&par2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parCompareParameters(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parCompareParameters(NULL, NULL, -1, -1, 1, 1, 1, 0.0, 0.0, status);
  if(n==0) {return 1;}
  
  PAR par1; parInit(&par1);
  PAR par2; parInit(&par2);

  if(verbose>1) printf("should not crash with empty PAR structs\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 1, 1, 0.0, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 2;}
  n=parCompareParameters(&par1, &par2, 1, 1, 1, 1, 1, 0.0, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 3;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_par(&par1); if(ret==TPCERROR_OK) ret=create_par(&par2); 
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 11;}
  n=parCompareParameters(&par1, &par2, 0, -1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 12;}
  n=parCompareParameters(&par1, &par2, -1, 0, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 13;}
  /* but too large index should have no match */
  n=parCompareParameters(&par1, &par2, 9999, -1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 15;}
  n=parCompareParameters(&par1, &par2, -1, 9999, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 16;}

  if(verbose>1) printf("fail, if no test is specified\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 0, 0, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 21;}
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 0, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 22;}


  if(verbose>1) printf("different p values should not match\n");
  par1.r[1].p[1]=123.4;
  par2.r[1].p[1]=123.5;
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 101;}
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 102;}
  if(verbose>1) printf("... except if just that is not tested\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 1, 0, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 103;}
  n=parCompareParameters(&par1, &par2, 1, 1, 1, 0, 0, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 104;}
  n=parCompareParameters(&par1, &par2, 0, 1, 1, 0, 0, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 105;}
  if(verbose>1) printf("... except if difference is within the limit\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 0.15, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 106;}
  if(verbose>1) printf("... or relative limit\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 0.0, 0.01, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 107;}
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 0.0, 0.00001, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 108;}


  if(verbose>1) printf("different sd values should not match\n");
  par1.r[1].p[1]=123.4;
  par2.r[1].p[1]=123.4;
  par1.r[1].sd[1]=12.34;
  par2.r[1].sd[1]=12.35;
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 201;}
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 1, 0, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 202;}
  if(verbose>1) printf("... except if just that is not tested\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 0, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 203;}
  n=parCompareParameters(&par1, &par2, 1, 1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 204;}
  n=parCompareParameters(&par1, &par2, 0, 1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 205;}
  if(verbose>1) printf("... except if difference is within the limit\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 1, 0, 0.015, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 206;}
  if(verbose>1) printf("... or relative limit\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 1, 0, 0.0, 0.01, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 207;}
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 1, 0, 0.0, 0.00001, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 208;}


  if(verbose>1) printf("different CL values should not match\n");
  par1.r[1].sd[1]=12.34;
  par2.r[1].sd[1]=12.34;
  par1.r[1].cl1[1]=113.4; par1.r[1].cl2[1]=133.4;
  par2.r[1].cl1[1]=113.5; par2.r[1].cl2[1]=133.4;
  par1.r[2].cl1[1]=113.4; par1.r[2].cl2[1]=133.4;
  par2.r[2].cl1[1]=113.4; par2.r[2].cl2[1]=133.5;
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 0, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 301;}
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 302;}
  if(verbose>1) printf("... except if just that is not tested\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 1, 1, 0, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 303;}
  n=parCompareParameters(&par1, &par2, 1, 1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 304;}
  n=parCompareParameters(&par1, &par2, 0, 1, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 305;}
  n=parCompareParameters(&par1, &par2, 1, 0, 1, 1, 1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 306;}
  if(verbose>1) printf("... except if difference is within the limit\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 0, 1, 0.15, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 307;}
  if(verbose>1) printf("... or relative limit\n");
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 0, 1, 0.0, 0.01, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 308;}
  n=parCompareParameters(&par1, &par2, -1, -1, 0, 0, 1, 0.0, 0.00001, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 309;}
  
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par1); parFree(&par2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parCompareWSS(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parCompareWSS(NULL, NULL, -1, 0.0, 0.0, status);
  if(n==0) {return 1;}
  
  PAR par1; parInit(&par1);
  PAR par2; parInit(&par2);

  if(verbose>1) printf("should not crash with empty PAR structs\n");
  n=parCompareWSS(&par1, &par2, -1, 0.0, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 2;}
  n=parCompareWSS(&par1, &par2,  1, 0.0, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 3;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_par(&par1); if(ret==TPCERROR_OK) ret=create_par(&par2); 
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=parCompareWSS(&par1, &par2, -1, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 11;}
  n=parCompareWSS(&par1, &par2, 0, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 12;}
  /* but too large index should have no match */
  n=parCompareWSS(&par1, &par2, 9999, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 15;}


  if(verbose>1) printf("different WSS values should not match\n");
  par1.r[1].wss=123.4;
  par2.r[1].wss=123.5;
  n=parCompareWSS(&par1, &par2, -1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 101;}
  n=parCompareWSS(&par1, &par2,  1, 1.0E-20, 0.0, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 102;}
  if(verbose>1) printf("... except if just that is not tested\n");
  n=parCompareWSS(&par1, &par2,  0, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 103;}
  n=parCompareWSS(&par1, &par2,  2, 1.0E-20, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 104;}
  if(verbose>1) printf("... except if difference is within the limit\n");
  n=parCompareWSS(&par1, &par2, -1, 0.15, 0.0, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 105;}
  if(verbose>1) printf("... or relative limit\n");
  n=parCompareWSS(&par1, &par2, -1, 0.0, 0.01, status);
  if(n!=0) {parFree(&par1); parFree(&par2); return 106;}
  n=parCompareWSS(&par1, &par2, -1, 0.0, 0.00001, status);
  if(n==0) {parFree(&par1); parFree(&par2); return 107;}

  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par1); parFree(&par2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
