/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parWriteXML(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par; parInit(&par);
  char *fname="parWriteXML.xml";
  FILE *fp;

  if(verbose>1) printf("test with NULL data\n");
  ret=parWriteXML(NULL, stdout, NULL); if(ret==0) return(1);
  if(verbose>1) printf("test with empty data\n");
  ret=parWriteXML(&par, stdout, NULL); if(ret==0) return(2);

  if(verbose>1) printf("creating test data\n");
  if(create_par(&par)) {parFree(&par); return(10);}
  for(int i=0; i<par.tacNr; i++) par.r[i].model=modelCodeIndex("pol4");

  if(verbose>1) printf("saving test data in '%s'\n", fname);
  fp=fopen(fname, "w"); if(fp==NULL) {parFree(&par); return(11);}
  ret=parWriteXML(&par, fp, status); fclose(fp); 
  if(ret!=0) {
    fprintf(stdout, "Error: %s\n", errorMsg(ret));
    parFree(&par); return(12);
  }

  /* What was written is not yet tested */

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
