/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcstatist.h"
/*****************************************************************************/

/*****************************************************************************/
int test_statMeanSD(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, ret, n, vn;
  
  /* We should get error with stupid input */
  ret=statMeanSD(NULL, 10, NULL, NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return 1;
  
  {
    n=20;
    double data[n], mean, sd;
    
    if(verbose>1) printf("all data is zeroes:\n");
    for(i=0; i<n; i++) data[i]=0.0;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(11);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(0.0, mean, 1.0E-10)) return 12;
    if(!doubleMatch(0.0, sd, 1.0E-10)) return 13;
    if(vn!=n) return(14);
    
    if(verbose>1) printf("all data is 10:\n");
    for(i=0; i<n; i++) data[i]=10.0;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(21);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(10.0, mean, 1.0E-10)) return 22;
    if(!doubleMatch(0.0, sd, 1.0E-10)) return 23;
    if(vn!=n) return(24);
    
    if(verbose>1) printf("one NaN:\n");
    for(i=0; i<n; i++) data[i]=10.0; 
    data[n/2]=nan("");
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(31);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(10.0, mean, 1.0E-10)) return 32;
    if(!doubleMatch(0.0, sd, 1.0E-10)) return 33;
    if(vn!=n-1) return(34);
    
    if(verbose>1) printf("all data is NaN:\n");
    for(i=0; i<n; i++) data[i]=nan("");
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret==0) return(41);
  }
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  
  {
    n=3;
    double data[n], mean, sd;
    
    if(verbose>1) printf("testing sd:\n");
    data[0]=-10.0; data[1]=+10.0; data[2]=0.0;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(101);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(0.0, mean, 1.0E-10)) return 102;
    if(!doubleMatch(10.0, sd, 1.0E-10)) return 103;
    if(vn!=n) return(104);

    if(verbose>1) printf("sd when mean is not required:\n");
    sd=999.0;
    ret=statMeanSD(data, n, NULL, &sd, NULL);
    if(ret!=0) return(111);
    if(verbose>2) printf("sd=%g\n", sd);
    if(!doubleMatch(10.0, sd, 1.0E-10)) return 113;

    if(verbose>1) printf("mean when sd is not required:\n");
    mean=999.0;
    ret=statMeanSD(data, n, &mean, NULL, NULL);
    if(ret!=0) return(121);
    if(verbose>2) printf("mean=%g\n", mean);
    if(!doubleMatch(0.0, mean, 1.0E-10)) return 122;
  }
  statusSet(status, __func__, __FILE__, __LINE__, 0);


  {
    n=20;
    double data[n], mean, sd;
    
    if(verbose>1) printf("\n Data and SD are very close to zero:\n");
    for(i=0; i<n; i++) data[i]=1.0E-20;
    data[2]=1.01E-20;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(201);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(1.0005E-20, mean, 1.0E-24)) return 202;
    if(!doubleMatch(2.236E-23, sd, 1.0E-25)) return 203;
    if(vn!=n) return(204);
    
    if(verbose>1) printf("\n Data is far from zero, and SD is relatively low:\n");
    for(i=0; i<n; i++) data[i]=1.0E+20;
    data[2]+=1.0;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(211);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(1.0E+20, mean, 1.0E-01)) return 212;
    if(!doubleMatch(0.0, sd, 1.0E-01)) return 213;
    if(vn!=n) return(214);
    
    if(verbose>1) printf("\n Data mean and SD are very high:\n");
    for(i=0; i<n; i++) data[i]=1.0E-20;
    data[2]=2.0E+21;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(301);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!doubleMatch(1.0E+20, mean, 1.0E-19)) return 302;
    if(!doubleMatch(4.47214E+20, sd, 1.0E+15)) return 303;
    if(vn!=n) return(304);
    
    if(verbose>1) printf("\n Data mean is zero but SD is very high:\n");
    for(i=0; i<n; i++) data[i]=0.0;
    data[2]=1.0E+21; data[3]=-1.0E+21;
    ret=statMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(401);
    if(verbose>2) printf("mean=%e sd=%e vn=%d\n", mean, sd, vn);
    if(!doubleMatch(0.0, mean, 1.0E-30)) return 402;
    if(!doubleMatch(3.244428E+20, sd, 1.0E+15)) return 403;
    if(vn!=n) return(404);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fstatMeanSD(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, ret, n, vn;
  
  /* We should get error with stupid input */
  ret=fstatMeanSD(NULL, 10, NULL, NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return 1;
  
  {
    n=20;
    float data[n], mean, sd;
    
    if(verbose>1) printf("all data is zeroes:\n");
    for(i=0; i<n; i++) data[i]=0.0;
    ret=fstatMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(11);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!floatMatch(0.0, mean, 1.0E-10)) return 12;
    if(!floatMatch(0.0, sd, 1.0E-10)) return 13;
    if(vn!=n) return(14);
    
    if(verbose>1) printf("all data is 10:\n");
    for(i=0; i<n; i++) data[i]=10.0;
    ret=fstatMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(21);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!floatMatch(10.0, mean, 1.0E-10)) return 22;
    if(!floatMatch(0.0, sd, 1.0E-10)) return 23;
    if(vn!=n) return(24);
    
    if(verbose>1) printf("one NaN:\n");
    for(i=0; i<n; i++) data[i]=10.0; 
    data[n/2]=nan("");
    ret=fstatMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(31);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!floatMatch(10.0, mean, 1.0E-10)) return 32;
    if(!floatMatch(0.0, sd, 1.0E-10)) return 33;
    if(vn!=n-1) return(34);
    
    if(verbose>1) printf("all data is NaN:\n");
    for(i=0; i<n; i++) data[i]=nan("");
    ret=fstatMeanSD(data, n, &mean, &sd, &vn);
    if(ret==0) return(41);
  }
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  
  {
    n=3;
    float data[n], mean, sd;
    
    if(verbose>1) printf("testing sd:\n");
    data[0]=-10.0; data[1]=+10.0; data[2]=0.0;
    ret=fstatMeanSD(data, n, &mean, &sd, &vn);
    if(ret!=0) return(101);
    if(verbose>2) printf("mean=%g sd=%g vn=%d\n", mean, sd, vn);
    if(!floatMatch(0.0, mean, 1.0E-10)) return 102;
    if(!floatMatch(10.0, sd, 1.0E-10)) return 103;
    if(vn!=n) return(104);

    if(verbose>1) printf("sd when mean is not required:\n");
    sd=999.0;
    ret=fstatMeanSD(data, n, NULL, &sd, NULL);
    if(ret!=0) return(111);
    if(verbose>2) printf("sd=%g\n", sd);
    if(!floatMatch(10.0, sd, 1.0E-10)) return 113;

    if(verbose>1) printf("mean when sd is not required:\n");
    mean=999.0;
    ret=fstatMeanSD(data, n, &mean, NULL, NULL);
    if(ret!=0) return(121);
    if(verbose>2) printf("mean=%g\n", mean);
    if(!floatMatch(0.0, mean, 1.0E-10)) return 122;
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
