/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcift.h"
#include "tpcisotope.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_mtacInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  MTAC mtac;
  mtacInit(&mtac);
  mtacInit((MTAC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mtacFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  mtacFree((MTAC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  MTAC mtac;  mtacInit(&mtac); mtacFree(&mtac);
  if(verbose>1) printf("did not segfault, that is good.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mtacAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(mtacAllocate(NULL, 0)!=TPCERROR_FAIL) return(1);

  MTAC mtac; mtacInit(&mtac); 
  int ret=mtacAllocate(&mtac, 0);
  if(ret!=TPCERROR_OK) return(2);

  ret=mtacAllocate(&mtac, 2);
  if(ret!=TPCERROR_OK) {mtacFree(&mtac); return(3);}
  if(mtac._nr!=2 || mtac.nr!=0) {mtacFree(&mtac); return(3);}

  mtacFree(&mtac);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mtacAllocateMore(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(mtacAllocateMore(NULL, 0)!=TPCERROR_FAIL) return(1);

  MTAC mtac; mtacInit(&mtac); 
  int ret=mtacAllocateMore(&mtac, 0);
  if(ret!=TPCERROR_OK) return(2);

  ret=mtacAllocate(&mtac, 2);
  if(ret!=TPCERROR_OK) {mtacFree(&mtac); return(11);}
  if(mtac._nr!=2 || mtac.nr!=0) {mtacFree(&mtac); return(12);}
  mtac.nr=2;
  ret=mtacAllocateMore(&mtac, 3);
  if(ret!=TPCERROR_OK) {mtacFree(&mtac); return(13);}
  if(mtac._nr!=5 || mtac.nr!=2) {mtacFree(&mtac); return(14);}
  ret=mtacAllocateMore(&mtac, 3);
  if(ret!=TPCERROR_OK) {mtacFree(&mtac); return(15);}
  if(mtac._nr!=5 || mtac.nr!=2) {mtacFree(&mtac); return(16);}

  mtacFree(&mtac);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mtacAddTAC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(mtacAddTAC(NULL, NULL)!=TPCERROR_FAIL) return(1);

  if(verbose>1) {printf("creating test data\n"); fflush(stdout);}
  TAC tac; tacInit(&tac); 
  if(create_tac(&tac)) return(10);

  MTAC mtac; mtacInit(&mtac); 
  if(verbose>1) {printf("adding TAC to empty list\n"); fflush(stdout);}
  int ret=mtacAddTAC(&mtac, &tac); if(verbose>1) {printf(" -> %s\n", errorMsg(ret)); fflush(stdout);}
  if(ret!=TPCERROR_OK) {mtacFree(&mtac); tacFree(&tac); return(11);}
  if(mtac.nr!=1 || mtac._nr!=1) {mtacFree(&mtac); tacFree(&tac); return(12);}
  if(tacCompareUnit(&tac, &mtac.tac[0], NULL) || 
     tacCompareNames(&tac, &mtac.tac[0], -1, NULL) ||
     tacCompareConc(&tac, &mtac.tac[0], -1, 1.0E-08, 1.0E-06, NULL) ||
     tacCompareTimes(&tac, &mtac.tac[0], 1.0E-08, 1.0E-06, NULL)) 
  {
    mtacFree(&mtac); tacFree(&tac); return(13);
  }

  if(verbose>1) {printf("adding TAC to list with previous data\n"); fflush(stdout);}
  ret=mtacAddTAC(&mtac, &tac); if(verbose>1) {printf(" -> %s\n", errorMsg(ret)); fflush(stdout);}
  if(ret!=TPCERROR_OK) {mtacFree(&mtac); tacFree(&tac); return(14);}
  if(mtac.nr!=2 || mtac._nr!=2) {mtacFree(&mtac); tacFree(&tac); return(15);}
  if(tacCompareUnit(&mtac.tac[1], &mtac.tac[0], NULL) || 
     tacCompareNames(&mtac.tac[1], &mtac.tac[0], -1, NULL) ||
     tacCompareConc(&mtac.tac[1], &mtac.tac[0], -1, 1.0E-08, 1.0E-06, NULL) ||
     tacCompareTimes(&mtac.tac[1], &mtac.tac[0], 1.0E-08, 1.0E-06, NULL)) 
  {
    mtacFree(&mtac); tacFree(&tac); return(16);
  }

  mtacFree(&mtac);
  tacFree(&tac);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
