/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacSelectTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int n, ret;
  TAC tac; tacInit(&tac);
  
  /* Empty TAC struct */
  n=tacSelectTACs(&tac, NULL, 0, status);
  if(n>0) {tacFree(&tac); return 1;}
  
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 2;}

  /* Select all */
  n=tacSelectTACs(&tac, NULL, 0, status);
  if(n!=tac.tacNr) {tacFree(&tac); return 11;}
  if(n!=tacSelectedTACs(&tac)) {tacFree(&tac); return 12;}
  /* Deselect all */
  n=tacSelectTACs(&tac, "meh", 1, status);
  if(n!=0) {tacFree(&tac); return 13;}
  if(tacSelectedTACs(&tac)!=0) {tacFree(&tac); return 14;}
  
  /* Empty string should not select anything when names exist */
  n=tacSelectTACs(&tac, "", 0, status);
  if(n!=0) {tacFree(&tac); return 15;}

  /* Select one at a time */
  n=tacSelectTACs(&tac, "ROI3", 0, status);
  if(n!=1) {tacFree(&tac); return 21;}
  n=tacSelectTACs(&tac, "roi2", 0, status);
  if(n!=1) {tacFree(&tac); return 22;}
  if(tacSelectedTACs(&tac)!=2) {tacFree(&tac); return 23;}
  n=tacSelectTACs(&tac, "roi1", 0, status);
  if(n!=1) {tacFree(&tac); return 24;}
  if(tacSelectedTACs(&tac)!=3) {tacFree(&tac); return 25;}

  /* Select one, deselecting others */
  n=tacSelectTACs(&tac, "Roi2", 1, status);
  if(n!=1) {tacFree(&tac); return 31;}
  if(tacSelectedTACs(&tac)!=1) {tacFree(&tac); return 32;}

  /* Deselect all */
  n=tacSelectTACs(&tac, "meh", 1, status);
  if(tacSelectedTACs(&tac)!=0) {tacFree(&tac); return 41;}
  /* Empty one of names */
  strcpy(tac.c[1].name, "");
  /* Now that one can be selected with "" */
  n=tacSelectTACs(&tac, "", 1, status);
  if(n!=1) {tacFree(&tac); return 42;}
  if(tacSelectedTACs(&tac)!=1) {tacFree(&tac); return 43;}

  /* Test with tac numbers */
  /* Deselect all */
  n=tacSelectTACs(&tac, "meh", 1, status);
  if(n!=0) {tacFree(&tac); return 51;}
  if(tacSelectedTACs(&tac)!=0) {tacFree(&tac); return 52;}
  /* Rename rois to not contain numbers */
  for(int ri=0; ri<tac.tacNr; ri++) strcpy(tac.c[ri].name, "name");
  /* Select 2nd TAC */
  n=tacSelectTACs(&tac, "'2'", 1, status);
  if(n!=1) {tacFree(&tac); return 53;}
  if(tac.c[1].sw==0)  {tacFree(&tac); return 54;}
  /* Select 1st TAC */
  n=tacSelectTACs(&tac, "1", 1, status);
  if(n!=1) {tacFree(&tac); return 55;}
  if(tac.c[0].sw==0)  {tacFree(&tac); return 56;}
  if(tacSelectedTACs(&tac)!=1) {tacFree(&tac); return 57;}
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSelectedTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>0) printf("tested with test_tacSelectTACs()\n");
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacFirstSelected(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  /* Empty TAC struct */
  if(tacFirstSelected(NULL)>=0) return(1);
  TAC tac; tacInit(&tac);
  if(tacFirstSelected(&tac)>=0) return(2);

  /* None selected */
  int ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 10;}
  if(tacFirstSelected(&tac)>=0) return(11);
  /* Some selected */
  tac.c[0].sw=1; if(tacFirstSelected(&tac)!=0) return(21);
  tac.c[1].sw=1; if(tacFirstSelected(&tac)!=0) return(22);
  tac.c[0].sw=0; if(tacFirstSelected(&tac)!=1) return(23);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSelectBestReference(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int n, ret;
  TAC tac; tacInit(&tac);
  
  /* Empty TAC struct */
  n=tacSelectBestReference(&tac);
  if(n>=0) {tacFree(&tac); return 1;}
  
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 2;}

  /* None preselected */
  n=tacSelectBestReference(&tac);
  if(n>=0) {tacFree(&tac); return 3;}

  /* Set reasonable TAC names */
  strcpy(tac.c[0].name, "Cer_dx");
  strcpy(tac.c[1].name, "Cer_sin");
  strcpy(tac.c[2].name, "Cer");
  n=tacSelectTACs(&tac, "cer", 1, status);
  if(n!=3) {tacFree(&tac); return 11;}
  n=tacSelectBestReference(&tac);
  if(n!=2) {tacFree(&tac); return 12;}

  strcpy(tac.c[2].name, "Cer_Mean");
  n=tacSelectTACs(&tac, "cer", 1, status);
  if(n!=3) {tacFree(&tac); return 13;}
  n=tacSelectBestReference(&tac);
  if(n!=2) {tacFree(&tac); return 14;}

  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
