/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacXUnitConvert(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  ret=tacXUnitConvert(&tac, UNIT_MIN, status);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}

  ret=tacXUnitConvert(&tac, UNIT_MIN, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}
  if(tac.tunit!=UNIT_MIN) {tacFree(&tac); return 13;}
  
  ret=tacXUnitConvert(&tac, UNIT_UNKNOWN, status);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 14;}

  double x; x=tac.x[2];
  ret=tacXUnitConvert(&tac, UNIT_SEC, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  if(tac.tunit!=UNIT_SEC) {tacFree(&tac); return 22;}
  if(!doubleMatch(x*60., tac.x[2], 1.0E-20)) {tacFree(&tac); return 23;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacYUnitConvert(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  ret=tacYUnitConvert(&tac, UNIT_KBQ_PER_ML, status);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}

  ret=tacYUnitConvert(&tac, UNIT_KBQ_PER_ML, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}
  if(tac.cunit!=UNIT_KBQ_PER_ML) {tacFree(&tac); return 13;}
  
  ret=tacYUnitConvert(&tac, UNIT_UNKNOWN, status);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 14;}

  double y; y=tac.c[1].y[2];
  ret=tacYUnitConvert(&tac, UNIT_BQ_PER_ML, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  if(tac.cunit!=UNIT_BQ_PER_ML) {tacFree(&tac); return 22;}
  if(!doubleMatch(y*1000., tac.c[1].y[2], 1.0E-20)) {tacFree(&tac); return 23;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacYUnitMass2Volume(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  if(verbose>1) {printf(" testing with empty data\n"); fflush(stdout);}
  ret=tacYUnitMass2Volume(&tac, 1.0, status);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  
  if(verbose>1) {printf("creating test data\n"); fflush(stdout);}
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  TAC tac2; tacInit(&tac2);
  ret=tacDuplicate(&tac, &tac2); if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}

  tac.cunit=UNIT_KBQ_PER_ML;
  ret=tacYUnitMass2Volume(&tac, 1.1, status);
  if(ret==TPCERROR_OK || tac.cunit!=UNIT_KBQ_PER_ML) {tacFree(&tac); tacFree(&tac2); return 21;}
  for(int ci=0; ci<tac.tacNr; ci++)
    for(int si=0; si<tac.sampleNr; si++)
      if(!doubleMatch(tac2.c[ci].y[si], tac.c[ci].y[si], 1.0E-10)) {
        tacFree(&tac); tacFree(&tac2); return 23;}
  
  tac.cunit=UNIT_KBQ_PER_G;
  ret=tacYUnitMass2Volume(&tac, 1.1, status);
  if(ret!=TPCERROR_OK || tac.cunit!=UNIT_KBQ_PER_ML) {tacFree(&tac); tacFree(&tac2); return 31;}
  for(int ci=0; ci<tac.tacNr; ci++)
    for(int si=0; si<tac.sampleNr; si++)
      if(!doubleMatch(1.1*tac2.c[ci].y[si], tac.c[ci].y[si], 1.0E-10)) {
        tacFree(&tac); tacFree(&tac2); return 33;}

  tacFree(&tac); tacFree(&tac2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacYUnitVolume2Mass(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  ret=tacYUnitVolume2Mass(&tac, 1.0, status);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  TAC tac2; tacInit(&tac2);
  ret=tacDuplicate(&tac, &tac2); if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}

  tac.cunit=UNIT_KBQ_PER_G;
  ret=tacYUnitVolume2Mass(&tac, 1.1, status);
  if(ret==TPCERROR_OK || tac.cunit!=UNIT_KBQ_PER_G) {tacFree(&tac); tacFree(&tac2); return 21;}
  for(int ci=0; ci<tac.tacNr; ci++)
    for(int si=0; si<tac.sampleNr; si++)
      if(!doubleMatch(tac2.c[ci].y[si], tac.c[ci].y[si], 1.0E-10)) {
        tacFree(&tac); tacFree(&tac2); return 23;}

  tac.cunit=UNIT_KBQ_PER_ML;
  ret=tacYUnitVolume2Mass(&tac, 1.1, status);
  if(ret!=TPCERROR_OK || tac.cunit!=UNIT_KBQ_PER_G) {tacFree(&tac); tacFree(&tac2); return 31;}
  for(int ci=0; ci<tac.tacNr; ci++)
    for(int si=0; si<tac.sampleNr; si++)
      if(!doubleMatch(tac2.c[ci].y[si]/1.1, tac.c[ci].y[si], 1.0E-10)) {
        tacFree(&tac); tacFree(&tac2); return 33;}
  
  tacFree(&tac); tacFree(&tac2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
