/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "unistd.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctacmod.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacPlotHistogramSVG(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  int ret;
  TAC tac; tacInit(&tac);
  char fname[128]; strcpy(fname, "");


  if(verbose>1) {printf("\n testing with NULL data.\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram0.svg");
  ret=tacPlotHistogramSVG(NULL, NULL, 0.0, 0.0, 0.0, 0.0, fname, status);
  if(ret==TPCERROR_OK) return(1);
  if(access(fname, 0)!=-1) return(2);
  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacPlotHistogramSVG(&tac, "Main title", 0.0, 1.0, 0.0, 1.0, fname, status);
  if(ret==TPCERROR_OK) return(3);
  if(access(fname, 0)!=-1) return(4);



  if(verbose>1) {printf("\n creating test data\n"); fflush(stdout);}
  /* Allocate memory */
  ret=tacAllocate(&tac, 5, 1); if(ret!=TPCERROR_OK) return(10);
  tac.tacNr=1; tac.sampleNr=5;
  /* Set TAC information */
  tac.isframe=0;
  /* Set region names */
  for(int i=0; i<tac.tacNr; i++) sprintf(tac.c[i].name, "tac%d", 1+i);
  /* Set data contents */
  int ri=0, fi;
  fi=0; tac.x1[fi]=0.0; tac.x2[fi]=2.0;  tac.x[fi]=1.0;  tac.c[ri].y[fi]=20.0;
  fi=1; tac.x1[fi]=2.0; tac.x2[fi]=4.0;  tac.x[fi]=3.0;  tac.c[ri].y[fi]=10.0;
  fi=2; tac.x1[fi]=4.0; tac.x2[fi]=6.0;  tac.x[fi]=5.0;  tac.c[ri].y[fi]=60.0;
  fi=3; tac.x1[fi]=6.0; tac.x2[fi]=10.0; tac.x[fi]=8.0;  tac.c[ri].y[fi]=40.0;
  fi=4; tac.x1[fi]=10.; tac.x2[fi]=13.0; tac.x[fi]=11.5; tac.c[ri].y[fi]=50.0;


  if(verbose>1) {printf("\n plotting test data with x\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram1.svg"); (void)remove(fname);
  tac.isframe=0;
  ret=tacPlotHistogramSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), fname, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(11);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(12);}

  if(verbose>1) {printf("\n plotting test data with x1 and x2\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram2.svg"); (void)remove(fname);
  tac.isframe=1;
  ret=tacPlotHistogramSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), fname, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(21);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(22);}

  for(fi=0; fi<tac.sampleNr; fi++) for(ri=0; ri<tac.tacNr; ri++) tac.c[ri].y[fi]*=-1.0;

  if(verbose>1) {printf("\n plotting negative test data with x1 and x2\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram2n.svg"); (void)remove(fname);
  tac.isframe=1;
  ret=tacPlotHistogramSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), fname, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(23);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(24);}

  if(verbose>1) {printf("\n plotting negative test data with x\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram1n.svg"); (void)remove(fname);
  tac.isframe=0;
  ret=tacPlotHistogramSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), fname, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(13);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(14);}

  for(fi=0; fi<tac.sampleNr; fi++) for(ri=0; ri<tac.tacNr; ri++) tac.c[ri].y[fi]+=35.0;

  if(verbose>1) {printf("\n plotting +/- test data with x\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram1np.svg"); (void)remove(fname);
  tac.isframe=0;
  ret=tacPlotHistogramSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), fname, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(15);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(16);}

  if(verbose>1) {printf("\n plotting +/- test data with x1 and x2\n"); fflush(stdout);}
  strcpy(fname, "tacplothistogram2np.svg"); (void)remove(fname);
  tac.isframe=1;
  ret=tacPlotHistogramSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), fname, status);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(25);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(26);}


  fflush(stdout); fflush(stderr);
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
