/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "unistd.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctacmod.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacInput2sim(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(status!=NULL) status->verbose-=3;

  if(verbose>1) printf("\n testing with NULL data.\n");
  if(tacInput2sim(NULL, NULL, NULL, status)==TPCERROR_OK) return(1);

  TAC itac; tacInit(&itac);
  TAC ttac; tacInit(&ttac);
  TAC stac; tacInit(&stac);

  if(verbose>1) printf("\n testing with empty data.\n");
  if(tacInput2sim(&itac, &ttac, &stac, status)==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n Both data with the same frame start and end times.\n");
  if(tacAllocate(&itac, 2, 1)) {tacFree(&itac); tacFree(&ttac); return(100);}
  if(tacAllocate(&ttac, 2, 1)) {tacFree(&itac); tacFree(&ttac); return(101);}
  itac.isframe=ttac.isframe=1;
  itac.tunit=ttac.tunit=UNIT_MIN;
  itac.x1[0]=ttac.x1[0]=0.0;
  itac.x2[0]=ttac.x2[0]=2.0;
  itac.x1[1]=ttac.x1[1]=2.0;
  itac.x2[1]=ttac.x2[1]=4.0;
  itac.c[0].y[0]=ttac.c[0].y[0]=1.0;
  itac.c[0].y[1]=ttac.c[0].y[0]=2.0;
  itac.sampleNr=ttac.sampleNr=2;
  itac.tacNr=ttac.tacNr=1;
  if(tacInput2sim(&itac, &ttac, &stac, status)!=TPCERROR_OK) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(102);
  }
//  tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  if(stac.isframe!=0 || stac.sampleNr!=5) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(103);
  }
  if(stac.x[0]!=0.0 || stac.x[1]!=1.0 || stac.x[2]!=2.0 || stac.x[3]!=3.0 || stac.x[4]!=4.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(104);
  }
  if(stac.c[0].y[0]!=0.0 || stac.c[0].y[1]!=1.0 || stac.c[0].y[2]!=1.5 || 
     stac.c[0].y[3]!=2.0 || stac.c[0].y[4]!=2.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(105);
  }

  if(verbose>1) printf("\n The same but input with frame mid times.\n");
  tacSetX(&itac, NULL); itac.isframe=0; tacFree(&stac);
  if(tacInput2sim(&itac, &ttac, &stac, status)!=TPCERROR_OK) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(112);
  }
  if(stac.isframe!=0 || stac.sampleNr!=5) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(113);
  }
  if(stac.x[0]!=0.0 || stac.x[1]!=1.0 || stac.x[2]!=2.0 || stac.x[3]!=3.0 || stac.x[4]!=4.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(114);
  }
  if(stac.c[0].y[0]!=0.0 || stac.c[0].y[1]!=1.0 || stac.c[0].y[2]!=1.5 || 
     stac.c[0].y[3]!=2.0 || stac.c[0].y[4]!=2.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(115);
  }

  if(verbose>1) printf("\n Tissue with frame mid times, input with start and end times.\n");
  tacSetX(&ttac, NULL); ttac.isframe=0; itac.isframe=1; tacFree(&stac);
  if(tacInput2sim(&itac, &ttac, &stac, status)!=TPCERROR_OK) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(122);
  }
  if(stac.isframe!=0 || stac.sampleNr!=5) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(123);
  }
  if(stac.x[0]!=0.0 || stac.x[1]!=1.0 || stac.x[2]!=2.0 || stac.x[3]!=3.0 || stac.x[4]!=4.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(124);
  }
  if(stac.c[0].y[0]!=0.0 || stac.c[0].y[1]!=1.0 || stac.c[0].y[2]!=1.5 || 
     stac.c[0].y[3]!=2.0 || stac.c[0].y[4]!=2.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(125);
  }

  if(verbose>1) printf("\n Input and tissue with frame mid times.\n");
  ttac.isframe=0; itac.isframe=0; tacFree(&stac);
  if(tacInput2sim(&itac, &ttac, &stac, status)!=TPCERROR_OK) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(132);
  }
  if(stac.isframe!=0 || stac.sampleNr!=3) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(133);
  }
  if(stac.x[0]!=0.0 || stac.x[1]!=1.0 || stac.x[2]!=3.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(134);
  }
  if(stac.c[0].y[0]!=0.0 || stac.c[0].y[1]!=1.0 || stac.c[0].y[2]!=2.0) {
    if(verbose>0) tacWrite(&stac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacFree(&itac); tacFree(&ttac); tacFree(&stac); return(135);
  }

  tacFree(&itac); tacFree(&ttac); tacFree(&stac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(status!=NULL) status->verbose+=3;
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
