/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "unistd.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctacmod.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacPlotFitSVG(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  int ret;
  TAC tac, fit; tacInit(&tac); tacInit(&fit);
  char fname[128]; strcpy(fname, "");

  if(verbose>1) {printf("\n testing with NULL data.\n"); fflush(stdout);}
  strcpy(fname, "tacplotfitsvg0.svg");
  ret=tacPlotFitSVG(NULL, NULL, NULL, 0.0, 0.0, 0.0, 0.0, fname, NULL);
  if(ret==TPCERROR_OK) return(1);
  if(access(fname, 0)!=-1) return(2);
  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacPlotFitSVG(&tac, &fit, "Main title", 0.0, 1.0, 0.0, 1.0, fname, NULL);
  if(ret==TPCERROR_OK) return(3);
  if(access(fname, 0)!=-1) return(4);

  if(verbose>1) {printf("\n creating test data\n"); fflush(stdout);}
  ret=create_tac(&tac); if(ret==TPCERROR_OK) ret=create_tac(&fit); 
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return 10;}

  if(verbose>1) {printf("\n plotting test data with automatic data range\n"); fflush(stdout);}
  strcpy(fname, "tacplotfitsvg1.svg"); (void)remove(fname);
  ret=tacPlotFitSVG(&tac, &fit, "Main title", nan(""), nan(""), nan(""), nan(""), fname, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return(11);}
  if(access(fname, 0)==-1) {tacFree(&tac); tacFree(&fit); return(12);}

  if(verbose>1) {printf("\n plotting test data with fixed data range\n"); fflush(stdout);}
  strcpy(fname, "tacplotfitsvg2.svg"); (void)remove(fname);
  ret=tacPlotFitSVG(&tac, &fit, "Main title", 1.0, 4.1, 1.0, 14.0, fname, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return(21);}
  if(access(fname, 0)==-1) {tacFree(&tac); tacFree(&fit); return(22);}

  if(verbose>1) {printf("\n plotting test data with less fitted samples\n"); fflush(stdout);}
  strcpy(fname, "tacplotfitsvg3a.svg"); (void)remove(fname);
  fit.sampleNr--;
  ret=tacPlotFitSVG(&tac, &fit, "Main title", nan(""), nan(""), nan(""), nan(""), fname, NULL);
  fit.sampleNr++;
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return(21);}
  if(access(fname, 0)==-1) {tacFree(&tac); tacFree(&fit); return(22);}

  if(verbose>1) {printf("\n plotting test data with less measured samples\n"); fflush(stdout);}
  strcpy(fname, "tacplotfitsvg3b.svg"); (void)remove(fname);
  tac.sampleNr--;
  ret=tacPlotFitSVG(&tac, &fit, "Main title", nan(""), nan(""), nan(""), nan(""), fname, NULL);
  tac.sampleNr++;
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return(23);}
  if(access(fname, 0)==-1) {tacFree(&tac); tacFree(&fit); return(24);}

  if(verbose>1) {printf("\n different TAC nr should give an error\n"); fflush(stdout);}
  strcpy(fname, "tacplotfitsvg4.svg"); (void)remove(fname);
  fit.tacNr--;
  ret=tacPlotFitSVG(&tac, &fit, "Main title", nan(""), nan(""), nan(""), nan(""), fname, NULL);
  fit.tacNr++;
  if(ret==TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return(31);}
  if(access(fname, 0)!=-1) {tacFree(&tac); tacFree(&fit); return(32);}
  tac.tacNr--;
  ret=tacPlotFitSVG(&tac, &fit, "Main title", nan(""), nan(""), nan(""), nan(""), fname, NULL);
  tac.tacNr++;
  if(ret==TPCERROR_OK) {tacFree(&tac); tacFree(&fit); return(33);}
  if(access(fname, 0)!=-1) {tacFree(&tac); tacFree(&fit); return(34);}

  fflush(stdout); fflush(stderr);
  tacFree(&tac); tacFree(&fit);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacPlotLineSVG(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  int ret;
  TAC tac; tacInit(&tac);
  char fname[128]; strcpy(fname, "");

  if(verbose>1) {printf("\n testing with NULL data.\n"); fflush(stdout);}
  strcpy(fname, "tacplotlinesvg0.svg");
  ret=tacPlotLineSVG(NULL, NULL, 0.0, 0.0, 0.0, 0.0, fname, NULL);
  if(ret==TPCERROR_OK) return(1);
  if(access(fname, 0)!=-1) return(2);
  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacPlotLineSVG(&tac, "Main title", 0.0, 1.0, 0.0, 1.0, fname, NULL);
  if(ret==TPCERROR_OK) return(3);
  if(access(fname, 0)!=-1) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) {printf("\n creating test data\n"); fflush(stdout);}
  ret=create_tac(&tac);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 10;}

  if(verbose>1) {
    printf("\n plotting test data with automatic data range\n");
    fflush(stdout);
  }
  strcpy(fname, "tacplotlinesvg1.svg");
  (void)remove(fname);
  if(verbose>1)
    ret=tacPlotLineSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), 
                       fname, status);
  else
    ret=tacPlotLineSVG(&tac, "Main title", nan(""), nan(""), nan(""), nan(""), 
                       fname, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(11);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(12);}

  if(verbose>1) {
    printf("\n plotting test data with fixed data range\n");
    fflush(stdout);
  }
  strcpy(fname, "tacplotlinesvg2.svg"); (void)remove(fname);
  ret=tacPlotLineSVG(&tac, "Main title", 1.0, 4.1, 1.0, 14.0, fname, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return(21);}
  if(access(fname, 0)==-1) {tacFree(&tac); return(22);}

  fflush(stdout); fflush(stderr);
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
